/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.xml;

import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import org.aksw.jena_sparql_api.sparql.ext.xml.ListOverNodeList;
import org.w3c.dom.Node;

public class NamespaceResolver
implements NamespaceContext {
    protected Node xmlStartNode;

    public NamespaceResolver(Node xmlNode) {
        this.xmlStartNode = xmlNode;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Iterable traverser = Traverser.forTree(xmlNode -> new ListOverNodeList(xmlNode.getChildNodes())).breadthFirst((Object)this.xmlStartNode);
        String key = "".equals(prefix) ? null : prefix;
        String result = Streams.stream((Iterable)traverser).map(xmlNode -> xmlNode.lookupNamespaceURI(key)).filter(Objects::nonNull).findFirst().orElse(null);
        return result;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.xmlStartNode.lookupPrefix(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        throw new UnsupportedOperationException();
    }
}

