/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.xml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathNodes;
import org.aksw.commons.lambda.throwing.ThrowingSupplier;
import org.aksw.jena_sparql_api.sparql.ext.url.JenaUrlUtils;
import org.aksw.jena_sparql_api.sparql.ext.xml.NamespaceResolver;
import org.aksw.jena_sparql_api.sparql.ext.xml.NodeValueXml;
import org.aksw.jena_sparql_api.sparql.ext.xml.RDFDatatypeXml;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.rdfhdt.hdt.iterator.utils.Iter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

public class JenaXmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(JenaXmlUtils.class);

    public static NodeValue makeXmlNodeValue(Node node) {
        org.w3c.dom.Node xmlNode = JenaXmlUtils.extractXmlNode(node);
        if (xmlNode == null) {
            throw new RuntimeException("Not an xml node: " + String.valueOf(node));
        }
        return new NodeValueXml(xmlNode);
    }

    public static org.w3c.dom.Node extractXmlNode(NodeValue nv) {
        org.w3c.dom.Node result;
        if (nv instanceof NodeValueXml) {
            result = ((NodeValueXml)nv).getXmlNode();
        } else {
            Node node = nv.getNode();
            result = JenaXmlUtils.extractXmlNode(node);
        }
        return result;
    }

    public static org.w3c.dom.Node extractXmlNode(Node node) {
        Object value;
        org.w3c.dom.Node result = null;
        if (node != null && node.isLiteral() && (value = node.getLiteralValue()) instanceof org.w3c.dom.Node) {
            result = (org.w3c.dom.Node)value;
        }
        return result;
    }

    public static String toString(org.w3c.dom.Node xmlNode) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JenaXmlUtils.toText(xmlNode, baos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String result = baos.toString();
        return result;
    }

    public static void toText(org.w3c.dom.Node xmlNode, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(xmlNode);
        StreamResult output = new StreamResult(out);
        transformer.transform(source, output);
    }

    public static NodeValue parse(InputStream in, RDFDatatypeXml dtype) {
        NodeValueXml result;
        try {
            Document xmlNode = dtype.getDocumentBuilder().parse(in);
            result = new NodeValueXml(xmlNode);
        }
        catch (Exception e) {
            throw new QueryExecException("Failed to parse xml from input stream");
        }
        return result;
    }

    public static NodeValue parse(ThrowingSupplier<InputStream> inSupp) throws Exception {
        NodeValue result;
        RDFDatatypeXml dtype = (RDFDatatypeXml)TypeMapper.getInstance().getTypeByClass(org.w3c.dom.Node.class);
        try (InputStream in = (InputStream)inSupp.get();){
            result = JenaXmlUtils.parse(in, dtype);
        }
        return result;
    }

    public static NodeValue resolve(NodeValue nv, FunctionEnv env) throws Exception {
        NodeValue result;
        block7: {
            RDFDatatypeXml dtype = (RDFDatatypeXml)TypeMapper.getInstance().getTypeByClass(org.w3c.dom.Node.class);
            try (InputStream in = JenaUrlUtils.openInputStream(nv, env);){
                if (in != null) {
                    result = JenaXmlUtils.parse(in, dtype);
                    break block7;
                }
                throw new ExprEvalException("Failed to obtain text from node " + String.valueOf(nv));
            }
        }
        return result;
    }

    public static Iterator<Node> iterateAsJenaNodes(XPathEvaluationResult<?> er, RDFDatatype xmlDatatype) {
        Iterator result = null;
        XPathEvaluationResult.XPathResultType type = er.type();
        Object value = er.value();
        Class<?> cls = value.getClass();
        TypeMapper tm = TypeMapper.getInstance();
        switch (type) {
            case BOOLEAN: 
            case NUMBER: 
            case STRING: {
                RDFDatatype dtype = tm.getTypeByClass(cls);
                result = Iter.single((Object)NodeFactory.createLiteralByValue(value, (RDFDatatype)dtype));
                break;
            }
            case NODE: {
                throw new IllegalStateException("Not implemented yet");
            }
            case NODESET: {
                XPathNodes xmlNodes = (XPathNodes)value;
                result = Iter.map((Iterable)xmlNodes, JenaXmlUtils::toJenaNode);
                break;
            }
            default: {
                throw new IllegalStateException("Should never come here: Result type was: " + String.valueOf((Object)type));
            }
        }
        return result;
    }

    public static Node toJenaNode(org.w3c.dom.Node xmlNode) {
        Node result;
        if (xmlNode instanceof Attr) {
            Attr attr = (Attr)xmlNode;
            result = NodeFactory.createLiteral((String)attr.getValue());
        } else if (xmlNode instanceof Text) {
            Text text = (Text)xmlNode;
            result = NodeFactory.createLiteral((String)text.getData());
        } else {
            result = NodeFactory.createLiteralByValue((Object)xmlNode, (RDFDatatype)RDFDatatypeXml.get());
        }
        return result;
    }

    public static Iterator<Node> evalXPath(XPathFactory xPathFactory, String queryStr, org.w3c.dom.Node xmlNode) throws XPathExpressionException {
        NamespaceResolver namespaceResolver = new NamespaceResolver(xmlNode);
        if (xmlNode instanceof Document && xmlNode.getChildNodes().getLength() == 1) {
            xmlNode = xmlNode.getFirstChild();
        }
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(namespaceResolver);
        XPathExpression expr = xPath.compile(queryStr);
        XPathEvaluationResult<?> er = expr.evaluateExpression(xmlNode);
        Iterator<Node> result = JenaXmlUtils.iterateAsJenaNodes(er, (RDFDatatype)RDFDatatypeXml.INSTANCE);
        return result;
    }

    public static QueryIterator evalXPath(XPathFactory xPathFactory, Binding binding, ExecutionContext execCxt, Node node, Node xpathNode, Var outputVar) {
        RDFDatatype xmlDatatype = TypeMapper.getInstance().getTypeByClass(org.w3c.dom.Node.class);
        Objects.requireNonNull(xmlDatatype);
        QueryIterator result = null;
        org.w3c.dom.Node xmlNode = JenaXmlUtils.extractXmlNode(node);
        if (xmlNode != null) {
            String queryStr;
            Object queryObj = xpathNode.isLiteral() ? xpathNode.getLiteralValue() : null;
            String string = queryStr = queryObj instanceof String ? (String)queryObj : null;
            if (queryStr != null) {
                try {
                    Iterator<Node> nodeIt = JenaXmlUtils.evalXPath(xPathFactory, queryStr, xmlNode);
                    Iterator bindingIt = Iter.map(nodeIt, jenaNode -> {
                        org.w3c.dom.Node reparsedXmlNode = (org.w3c.dom.Node)xmlDatatype.parse(jenaNode.getLiteralLexicalForm());
                        Node reparsedNode = NodeFactory.createLiteralByValue((Object)reparsedXmlNode, (RDFDatatype)xmlDatatype);
                        Binding b = BindingFactory.binding((Binding)binding, (Var)outputVar, (Node)reparsedNode);
                        return b;
                    });
                    result = QueryIterPlainWrapper.create((Iterator)bindingIt, (ExecutionContext)execCxt);
                }
                catch (Exception e) {
                    logger.warn(e.getLocalizedMessage());
                }
            }
        }
        if (result == null) {
            result = QueryIterNullIterator.create((ExecutionContext)execCxt);
        }
        return result;
    }
}

