/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.http;

import com.google.common.net.MediaType;
import com.google.gson.JsonElement;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E_Http
extends FunctionBase1 {
    private static final Logger logger = LoggerFactory.getLogger(E_Http.class);
    private Supplier<HttpClient> httpClientSupplier;

    public E_Http() {
        this(() -> new DefaultHttpClient());
    }

    public E_Http(HttpClient httpClient) {
        this(() -> httpClient);
    }

    public E_Http(Supplier<HttpClient> httpClientSupplier) {
        this.httpClientSupplier = httpClientSupplier;
    }

    public NodeValue exec(NodeValue nv) {
        NodeValue result;
        try {
            result = this._exec(nv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public NodeValue _exec(NodeValue nv) throws Exception {
        String url;
        if (nv.isString()) {
            url = nv.getString();
        } else if (nv.isIRI()) {
            Node node = nv.asNode();
            url = node.getURI();
        } else {
            throw new ExprEvalException("Neither IRI nor string");
        }
        NodeValue result = null;
        if (url != null) {
            HttpGet request = null;
            try {
                request = new HttpGet(url);
                HttpClient httpClient = this.httpClientSupplier.get();
                HttpResponse response = httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    String str = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
                    Header contentType = entity.getContentType();
                    String contentTypeValue = contentType.getValue();
                    boolean isJson = MediaType.parse((String)contentTypeValue).is(MediaType.JSON_UTF_8);
                    if (isJson) {
                        RDFDatatype jsonDatatype = TypeMapper.getInstance().getTypeByClass(JsonElement.class);
                        Node jsonNode = NodeFactory.createLiteral((String)str, (RDFDatatype)jsonDatatype);
                        result = NodeValue.makeNode((Node)jsonNode);
                    } else {
                        result = NodeValue.makeString((String)str);
                    }
                }
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (Exception e) {
                logger.warn("Http request failed", (Throwable)e);
                throw new ExprEvalException((Throwable)e);
            }
            finally {
                if (request != null) {
                    request.releaseConnection();
                }
            }
        }
        if (result == null) {
            throw new ExprEvalException("Http request returned non 200 status code");
        }
        return result;
    }
}

