/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.GeometryWrapperFactory;
import org.apache.jena.geosparql.spatial.property_functions.box.WithinBoxGeomPF;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;

public class WithinBoxMultipolygonPF
extends WithinBoxGeomPF {
    private static final int GEOM_POS = 0;
    private static final int LIMIT_POS = 1;

    public QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        List objectArgs = argObject.getArgList();
        if (objectArgs.size() < 1) {
            throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": Minimum of 1 arguments.");
        }
        if (objectArgs.size() > 2) {
            throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": Maximum of 2 arguments.");
        }
        Node geomLit = argObject.getArg(0);
        Node limitNode = objectArgs.size() > 1 ? (Node)objectArgs.get(1) : null;
        GeometryWrapper geometryWrapper = GeometryWrapper.extract((Node)geomLit);
        if (geometryWrapper.getGeometryType().equals("MultiPolygon")) {
            MultiPolygon mp = (MultiPolygon)geometryWrapper.getParsingGeometry();
            Iterator iterator = IntStream.range(0, mp.getNumGeometries()).mapToObj(arg_0 -> ((MultiPolygon)mp).getGeometryN(arg_0)).map(g -> GeometryWrapperFactory.createGeometry((Geometry)g, (String)geometryWrapper.getSrsURI(), (String)geometryWrapper.getGeometryDatatypeURI())).map(w -> new PropFuncArg(limitNode == null ? List.of(w.asNode()) : List.of(w.asNode(), limitNode))).map(argObjectTmp -> super.execEvaluated(binding, argSubject, predicate, argObjectTmp, execCxt)).flatMap(qIt -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(qIt, 16), false)).iterator();
            return QueryIterPlainWrapper.create(iterator, (ExecutionContext)execCxt);
        }
        return super.execEvaluated(binding, argSubject, predicate, argObject, execCxt);
    }

    public static void main(String[] args) {
        Iterator<Integer> it = Arrays.asList(1, 2, 3, 4, 5).iterator();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).forEach(System.out::println);
    }
}

