/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import com.google.common.base.Ascii;
import com.google.common.io.BaseEncoding;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.implementation.DimensionInfo;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.geosparql.implementation.parsers.wkt.WKTReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTWriter;

public class RDFDatatypeWkbLiteral
extends GeometryDatatype {
    protected WKBReader wkbReader;
    protected WKBWriter wkbWriter;
    protected WKTWriter wktWriter;
    public static final String URI = "http://www.opengis.net/ont/geosparql#wkbLiteral";
    public static final RDFDatatypeWkbLiteral INSTANCE = new RDFDatatypeWkbLiteral();

    public static RDFDatatype get() {
        return INSTANCE;
    }

    public RDFDatatypeWkbLiteral() {
        this(URI);
    }

    public RDFDatatypeWkbLiteral(String uri) {
        this(uri, new WKBReader(CustomGeometryFactory.theInstance()), new WKBWriter());
    }

    public RDFDatatypeWkbLiteral(String uri, WKBReader wkbReader, WKBWriter wkbWriter) {
        this(uri, wkbReader, wkbWriter, new WKTWriter());
    }

    public RDFDatatypeWkbLiteral(String uri, WKBReader wkbReader, WKBWriter wkbWriter, WKTWriter wktWriter) {
        super(uri);
        this.wkbReader = wkbReader;
        this.wkbWriter = wkbWriter;
        this.wktWriter = wktWriter;
    }

    public String unparse(Object geometry) {
        if (geometry instanceof GeometryWrapper) {
            GeometryWrapper geometryWrapper = (GeometryWrapper)geometry;
            byte[] bytes = this.wkbWriter.write(geometryWrapper.getParsingGeometry());
            String str = BaseEncoding.base64().encode(bytes);
            return str;
        }
        throw new DatatypeFormatException("Object to unparse WKBDatatype is not a GeometryWrapper: " + String.valueOf(geometry));
    }

    public GeometryWrapper read(String geometryLiteral) {
        byte[] bytes = BaseEncoding.base64().decode((CharSequence)geometryLiteral);
        try {
            Geometry geometry = this.wkbReader.read(bytes);
            String tmpGeoStr = this.wktWriter.write(geometry);
            WKTReader wktReader = WKTReader.extract((String)tmpGeoStr);
            String srsURI = wktReader.getSrsURI();
            DimensionInfo dimensionInfo = wktReader.getDimensionInfo();
            return new GeometryWrapper(geometry, srsURI, "http://www.opengis.net/ont/geosparql#wktLiteral", dimensionInfo, tmpGeoStr);
        }
        catch (ParseException e) {
            throw new DatatypeFormatException("Failed to parse geometry literal " + Ascii.truncate((CharSequence)geometryLiteral, (int)124, (String)"..."), (Throwable)e);
        }
    }

    public String toString() {
        return "WKBDatatype{http://www.opengis.net/ont/geosparql#wkbLiteral}";
    }
}

