/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.DbscanPf;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoSparqlExAggregators;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeometryWrapperUtils;
import org.aksw.jenax.annotation.reprogen.DefaultValue;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.arq.util.node.NodeCollection;
import org.aksw.jenax.arq.util.node.NodeList;
import org.aksw.jenax.arq.util.node.NodeListImpl;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.UnitsOfMeasure;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.FmtUtils;
import org.locationtech.jts.coverage.CoverageSimplifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.PolygonHullSimplifier;
import org.locationtech.jts.simplify.VWSimplifier;

public class GeoSparqlExFunctions {
    public static Stream<Geometry> expandCollection(Geometry geom) {
        Stream<Geometry> result;
        if (geom instanceof GeometryCollection) {
            GeometryCollection c = (GeometryCollection)geom;
            result = IntStream.range(0, c.getNumGeometries()).mapToObj(arg_0 -> ((GeometryCollection)c).getGeometryN(arg_0));
        } else {
            result = Stream.of(geom);
        }
        return result;
    }

    @Iri(value="https://w3id.org/aksw/norse#geo.collect")
    public static GeometryWrapper collect(Node ... nodes) {
        return GeoSparqlExFunctions.collect(NodeListImpl.wrap((Node[])nodes));
    }

    @Iri(value="https://w3id.org/aksw/norse#geo.asCollection")
    public static GeometryWrapper collect(NodeList nodeCollection) {
        ParallelAggregator<Binding, FunctionEnv, GeometryWrapper, ?> agg = GeoSparqlExAggregators.aggGeometryWrapperCollection((Expr)new ExprVar(Vars.x), false, false);
        Optional r = agg.accumulateAll(nodeCollection.stream().map(node -> BindingFactory.binding((Var)Vars.x, (Node)node)), null);
        return r.orElse(null);
    }

    @Iri(value="https://w3id.org/aksw/norse#geo.unwrapSingle")
    public static GeometryWrapper collect(GeometryWrapper geom, @DefaultValue(value="false") boolean recursive) {
        GeometryCollection c;
        Geometry init;
        Geometry current = init = geom.getParsingGeometry();
        while (current instanceof GeometryCollection && (c = (GeometryCollection)current).getNumGeometries() == 1) {
            current = c.getGeometryN(0);
            if (recursive) continue;
        }
        GeometryWrapper result = current == init ? geom : GeometryWrapperUtils.createFromPrototype(geom, current);
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper simplifyDp(GeometryWrapper geom, @DefaultValue(value="0") double tolerance, @DefaultValue(value="true") boolean ensureValid) {
        DouglasPeuckerSimplifier simplifier = new DouglasPeuckerSimplifier(geom.getParsingGeometry());
        simplifier.setDistanceTolerance(tolerance);
        simplifier.setEnsureValid(ensureValid);
        Geometry tmp = simplifier.getResultGeometry();
        return GeometryWrapperUtils.createFromPrototype(geom, tmp);
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper simplifyVW(GeometryWrapper geom, @DefaultValue(value="0") double tolerance, @DefaultValue(value="true") boolean ensureValid) {
        VWSimplifier simplifier = new VWSimplifier(geom.getParsingGeometry());
        simplifier.setDistanceTolerance(tolerance);
        simplifier.setEnsureValid(ensureValid);
        Geometry tmp = simplifier.getResultGeometry();
        return GeometryWrapperUtils.createFromPrototype(geom, tmp);
    }

    @IriNs(value="http://jena.apache.org/function/spatial#")
    public static GeometryWrapper union(GeometryWrapper geom) {
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geom, OverlayNGRobust.union((Geometry)geom.getParsingGeometry()));
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper intersection(GeometryWrapper geom1, GeometryWrapper geom2) {
        Geometry intersection = geom1.getParsingGeometry().intersection(geom2.getParsingGeometry());
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geom1, intersection);
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper difference(GeometryWrapper geom1, GeometryWrapper geom2) {
        Geometry difference = geom1.getParsingGeometry().difference(geom2.getParsingGeometry());
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geom1, difference);
        return result;
    }

    public static Geometry toCollectionIfNeeded(Geometry[] geoms) {
        Geometry result = geoms.length == 1 ? geoms[0] : CustomGeometryFactory.theInstance().createGeometryCollection(geoms);
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper simplifyCoverage(GeometryWrapper geom, @DefaultValue(value="0.1") double tolerance) {
        Geometry[] coverage = (Geometry[])GeoSparqlExFunctions.expandCollection(geom.getParsingGeometry()).toArray(Geometry[]::new);
        Geometry[] simplified = CoverageSimplifier.simplify((Geometry[])coverage, (double)tolerance);
        Geometry tmp = GeoSparqlExFunctions.toCollectionIfNeeded(simplified);
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geom, tmp);
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper lineMerge(GeometryWrapper geom) {
        LineMerger merger = new LineMerger();
        GeoSparqlExFunctions.expandCollection(geom.getParsingGeometry()).forEach(arg_0 -> ((LineMerger)merger).add(arg_0));
        Collection tmp = merger.getMergedLineStrings();
        if (tmp.isEmpty()) {
            throw new ExprEvalException("No line strings have been input of geof:lineMerge function. Can't make union of empty line strings after merge step.");
        }
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geom, OverlayNGRobust.union((Collection)tmp));
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper centroid(GeometryWrapper geom) {
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geom, (Geometry)geom.getParsingGeometry().getCentroid());
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double x(Geometry geom) {
        if (!(geom instanceof Point)) {
            throw new ExprEvalException("not a point");
        }
        return ((Point)geom).getX();
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double y(Geometry geom) {
        if (!(geom instanceof Point)) {
            throw new ExprEvalException("not a point");
        }
        return ((Point)geom).getY();
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double lon(GeometryWrapper geom) {
        return GeoSparqlExFunctions.x(GeometryWrapperUtils.toWgs84(geom).getParsingGeometry());
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double lat(GeometryWrapper geom) {
        return GeoSparqlExFunctions.y(GeometryWrapperUtils.toWgs84(geom).getParsingGeometry());
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double length(GeometryWrapper geom) {
        Geometry g = geom.getParsingGeometry();
        if (g instanceof LineString || g instanceof MultiLineString) {
            return g.getLength();
        }
        return 0.0;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double perimeter(GeometryWrapper geom) {
        Geometry g = geom.getParsingGeometry();
        if (g instanceof Polygon || g instanceof MultiPolygon) {
            return g.getLength();
        }
        return 0.0;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double area(GeometryWrapper geom) {
        Geometry g = geom.getParsingGeometry();
        return g.getArea();
    }

    @IriNs(value="http://jena.apache.org/function/spatial#")
    public static NodeList dbscan(NodeList arr, int geoIdx, double eps, int minPts) {
        return DbscanPf.dbscan((NodeCollection)arr, geoIdx, eps, minPts);
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper makeLine(GeometryWrapper geomWrapper) {
        GeometryFactory f = CustomGeometryFactory.theInstance();
        Geometry inGeom = geomWrapper.getParsingGeometry();
        GeometryCollection c = inGeom instanceof GeometryCollection ? (GeometryCollection)inGeom : f.createGeometryCollection(new Geometry[]{inGeom});
        Coordinate[] coords = c.getCoordinates();
        LineString outGeom = CustomGeometryFactory.theInstance().createLineString(coords);
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geomWrapper, (Geometry)outGeom);
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper project(GeometryWrapper geomWrapper, double distanceInMeters, double azimuthInRadians) {
        double earthRadius = 6371000.0;
        double srcLonDeg = GeoSparqlExFunctions.lon(geomWrapper);
        double srcLatDeg = GeoSparqlExFunctions.lat(geomWrapper);
        double srcLonRad = Math.toRadians(srcLonDeg);
        double srcLatRad = Math.toRadians(srcLatDeg);
        double angularDistance = distanceInMeters / earthRadius;
        double destLatRad = Math.asin(Math.sin(srcLatRad) * Math.cos(angularDistance) + Math.cos(srcLatRad) * Math.sin(angularDistance) * Math.cos(azimuthInRadians));
        double destLonRad = srcLonRad + Math.atan2(Math.sin(azimuthInRadians) * Math.sin(angularDistance) * Math.cos(srcLatRad), Math.cos(angularDistance) - Math.sin(srcLatRad) * Math.sin(destLatRad));
        destLonRad = (destLonRad + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        double destLonDeg = Math.toDegrees(destLonRad);
        double destLatDeg = Math.toDegrees(destLatRad);
        Point outGeom = CustomGeometryFactory.theInstance().createPoint(new Coordinate(destLonDeg, destLatDeg));
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geomWrapper, (Geometry)outGeom);
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double area(GeometryWrapper geom, Node areaUnitsURI) {
        if (!areaUnitsURI.isURI()) {
            throw new ExprEvalException("Not a IRI for area unit: " + FmtUtils.stringForNode((Node)areaUnitsURI));
        }
        Geometry g = geom.getXYGeometry();
        if (!g.getGeometryType().equals("Polygon")) {
            return 0.0;
        }
        double area = g.getArea();
        String unitsURI = geom.getUnitsOfMeasure().getUnitURI();
        double areaConverted = UnitsOfMeasure.conversion((double)area, (String)unitsURI, (String)areaUnitsURI.getURI());
        return areaConverted;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static double metricArea(GeometryWrapper geom) {
        return GeoSparqlExFunctions.area(geom, NodeFactory.createURI((String)"http://www.opengis.net/def/uom/OGC/1.0/metre"));
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static boolean isValid(GeometryWrapper geom) {
        return geom.isValid();
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper makeValid(GeometryWrapper geomWrapper) {
        Geometry fixedGeometry = GeometryFixer.fix((Geometry)geomWrapper.getParsingGeometry());
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geomWrapper, fixedGeometry);
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper hullByAreaDelta(GeometryWrapper geomWrapper, boolean isOuter, double areaDeltaRatio) {
        Geometry hull = PolygonHullSimplifier.hullByAreaDelta((Geometry)geomWrapper.getParsingGeometry(), (boolean)isOuter, (double)areaDeltaRatio);
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geomWrapper, hull);
        return result;
    }

    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper hullByVertexNumberFraction(GeometryWrapper geomWrapper, boolean isOuter, double vertexNumFraction) {
        Geometry hull = PolygonHullSimplifier.hull((Geometry)geomWrapper.getParsingGeometry(), (boolean)isOuter, (double)vertexNumFraction);
        GeometryWrapper result = GeometryWrapperUtils.createFromPrototype(geomWrapper, hull);
        return result;
    }
}

