/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import java.util.function.Function;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.F_ParseWkt;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinaryGeometryFunctionBase
extends FunctionBase2 {
    private static final Logger logger = LoggerFactory.getLogger(BinaryGeometryFunctionBase.class);
    protected Function<String, Geometry> wktParser = new F_ParseWkt();
    protected Function<Geometry, String> wktWriter = arg_0 -> ((WKTWriter)new WKTWriter()).write(arg_0);
    protected GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);

    public abstract Geometry eval(Geometry var1, Geometry var2);

    public NodeValue exec(NodeValue a, NodeValue b) {
        NodeValue result;
        String aStr = a.asNode().getLiteralLexicalForm();
        String bStr = b.asNode().getLiteralLexicalForm();
        Geometry aGeo = null;
        Geometry bGeo = null;
        try {
            aGeo = this.wktParser.apply(aStr);
            bGeo = this.wktParser.apply(bStr);
        }
        catch (Exception e) {
            logger.warn("Error parsing provided argument as WKT", (Throwable)e);
        }
        if (aGeo != null && bGeo != null) {
            Geometry g = this.eval(aGeo, bGeo);
            RDFDatatype dtype = TypeMapper.getInstance().getSafeTypeByName("http://www.opengis.net/ont/geosparql#wktLiteral");
            String str = g != null ? this.wktWriter.apply(g) : null;
            result = str == null ? null : NodeValue.makeNode((Node)NodeFactory.createLiteral((String)str, (RDFDatatype)dtype));
        } else {
            result = null;
        }
        return result;
    }
}

