/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.fs;

import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.sparql.ext.url.JenaUrlUtils;
import org.aksw.jenax.arq.util.security.ArqSecurity;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIx;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFunctionFactoryFsFind
implements PropertyFunctionFactory {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFunctionFactoryFsFind.class);
    protected Function<? super Path, ? extends Stream<? extends Path>> fn;

    public PropertyFunctionFactoryFsFind(Function<? super Path, ? extends Stream<? extends Path>> fn) {
        this.fn = fn;
    }

    public static Stream<Path> parents(Path path) {
        try {
            return Streams.stream((Iterable)Traverser.forTree(p -> p == null || p.getParent() == null ? Collections.emptySet() : Collections.singleton(p.getParent())).depthFirstPreOrder((Object)path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Path> find(Path path) {
        try {
            return Files.list(path).flatMap(f -> {
                Stream<Path> r = Stream.of(f);
                Stream<Path> s = null;
                try {
                    if (Files.isDirectory(f, new LinkOption[0])) {
                        s = PropertyFunctionFactoryFsFind.find(f);
                    }
                }
                catch (Exception e) {
                    logger.warn("Could not access path", (Throwable)e);
                }
                r = s == null ? r : Stream.concat(r, s);
                return r;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PropertyFunction create(String uri) {
        return new PathFunction(this.fn);
    }

    public static class PathFunction
    extends PFuncSimple {
        protected Function<? super Path, ? extends Stream<? extends Path>> fn;

        public PathFunction(Function<? super Path, ? extends Stream<? extends Path>> fn) {
            this.fn = fn;
        }

        public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCtx) {
            Node node;
            ArqSecurity.requireFileAccess((Context)execCtx.getContext());
            Node node2 = node = subject.isVariable() ? binding.get((Var)subject) : subject;
            if (!object.isVariable()) {
                throw new RuntimeException("Object of json array splitting must be a variable");
            }
            Var outputVar = (Var)object;
            Iterator bindings = Collections.emptyIterator();
            try {
                if (node.isURI()) {
                    String str = node.getURI();
                    IRIx irix = JenaUrlUtils.createIriX(NodeValue.makeString((String)str), (FunctionEnv)execCtx);
                    Object iri = irix.str();
                    if (((String)iri).isEmpty()) {
                        iri = "file://" + String.valueOf(Paths.get(str, new String[0]).toAbsolutePath());
                    }
                    Path root = Paths.get(new URI((String)iri));
                    bindings = this.fn.apply(root).map(path -> BindingFactory.binding((Binding)binding, (Var)outputVar, (Node)NodeFactory.createURI((String)path.toUri().toString()))).iterator();
                }
            }
            catch (Exception e) {
                logger.warn("Error resolving node as URI: " + String.valueOf(node), (Throwable)e);
            }
            QueryIterator result = QueryIterPlainWrapper.create(bindings);
            return result;
        }
    }
}

