/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.fs;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.aksw.jena_sparql_api.sparql.ext.fs.E_PathGet;
import org.aksw.jena_sparql_api.sparql.ext.fs.E_ProbeRdf;
import org.aksw.jena_sparql_api.sparql.ext.fs.E_RdfLang;
import org.aksw.jena_sparql_api.sparql.ext.fs.E_UnaryPathFunction;
import org.aksw.jena_sparql_api.sparql.ext.fs.PropertyFunctionFactoryFsFind;
import org.aksw.jena_sparql_api.sparql.ext.fs.probeEncoding;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.arq.functionbinder.FunctionBinder;
import org.aksw.jenax.arq.functionbinder.FunctionBinders;
import org.aksw.jenax.arq.functionbinder.FunctionGenerator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;

public class JenaExtensionFs {
    public static final String ns = "http://jsa.aksw.org/fn/fs/";

    public static void register() {
        FunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/rdfLang", E_RdfLang.class);
        FunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/probeRdf", E_ProbeRdf.class);
        FunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/get", E_PathGet.class);
        FunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/size", E_UnaryPathFunction.newFactory(path -> NodeValue.makeInteger((long)Files.size(path))));
        FunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/isDirectory", E_UnaryPathFunction.newFactory(path -> NodeValue.makeBoolean((boolean)Files.isDirectory(path, new LinkOption[0]))));
        FunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/isRegularFile", E_UnaryPathFunction.newFactory(path -> NodeValue.makeBoolean((boolean)Files.isRegularFile(path, new LinkOption[0]))));
        FunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/probeContentType", E_UnaryPathFunction.newFactory(path -> NodeValue.makeString((String)Files.probeContentType(path))));
        FunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/probeEncoding", E_UnaryPathFunction.newFactory(path -> NodeValue.makeString((String)probeEncoding.doProbeEncoding(path))));
        PropertyFunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/find", (PropertyFunctionFactory)new PropertyFunctionFactoryFsFind(PropertyFunctionFactoryFsFind::find));
        PropertyFunctionRegistry.get().put("http://jsa.aksw.org/fn/fs/parents", (PropertyFunctionFactory)new PropertyFunctionFactoryFsFind(PropertyFunctionFactoryFsFind::parents));
        FunctionBinder binder = FunctionBinders.getDefaultFunctionBinder();
        FunctionGenerator generator = binder.getFunctionGenerator();
        generator.getConverterRegistry().register(Path.class, Node.class, file -> NodeFactory.createURI((String)("file://" + file.toAbsolutePath().toString())), node -> {
            Path r;
            String str = node.getURI();
            try {
                URI uri = new URI(str);
                r = Path.of(uri);
            }
            catch (Exception e) {
                r = Path.of(str, new String[0]);
            }
            return r;
        });
        generator.getJavaToRdfTypeMap().put(Path.class, Node.class);
        binder.registerAll(JenaExtensionFs.class);
    }

    public static HashCode hashPath(Path path, HashFunction hashFunction) throws IOException {
        HashCode result;
        Hasher hasher = hashFunction.newHasher();
        try (OutputStream funnel = Funnels.asOutputStream((PrimitiveSink)hasher);){
            Files.copy(path, funnel);
            result = hasher.hash();
        }
        return result;
    }

    public static void addPrefixes(PrefixMapping pm) {
        pm.setNsPrefix("fs", ns);
    }

    public static void registerFileServiceHandler() {
        throw new RuntimeException("Global registration of file service handler was removed");
    }

    @IriNs(value="http://jsa.aksw.org/fn/fs/")
    public static String md5(Path path) throws IOException {
        return JenaExtensionFs.hashPath(path, Hashing.md5()).toString();
    }

    @IriNs(value="http://jsa.aksw.org/fn/fs/")
    public static String sha1(Path path) throws IOException {
        return JenaExtensionFs.hashPath(path, Hashing.sha1()).toString();
    }

    @IriNs(value="http://jsa.aksw.org/fn/fs/")
    public static String sha256(Path path) throws IOException {
        return JenaExtensionFs.hashPath(path, Hashing.sha256()).toString();
    }

    @IriNs(value="http://jsa.aksw.org/fn/fs/")
    public static String sha384(Path path) throws IOException {
        return JenaExtensionFs.hashPath(path, Hashing.sha384()).toString();
    }

    @IriNs(value="http://jsa.aksw.org/fn/fs/")
    public static String sha512(Path path) throws IOException {
        return JenaExtensionFs.hashPath(path, Hashing.sha512()).toString();
    }
}

