/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.distinct;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.commons.util.obj.ObjectUtils;
import org.aksw.jena_sparql_api.algebra.utils.OpServiceUtils;
import org.aksw.jena_sparql_api.sparql.ext.distinct.QueryIterDistinctConditional;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;

public class JenaPluginConditionalDistinct {
    public static final String SERVICE_IRI = "distinct:";
    public static final String CONDITION = "if:";
    public static final String PATTERN = "over:";

    public static void register(ServiceExecutorRegistry registry) {
        registry.addSingleLink((opExecute, opOriginal, binding, execCxt, chain) -> {
            Object r;
            if (SERVICE_IRI.equals(OpServiceUtils.getIriOrNull((OpService)opExecute))) {
                Collection pattern;
                Multimap args = OpServiceUtils.extractServiceArgs((OpService)opExecute);
                ArrayList<ExprList> conditions = new ArrayList<ExprList>(args.size());
                Collection cops = args.get((Object)CONDITION);
                for (Op cop : cops) {
                    OpFilter f = (OpFilter)ObjectUtils.castAsOrNull(OpFilter.class, (Object)cop);
                    if (f == null) {
                        throw new IllegalArgumentException("Only filters allowed in condition clause, instead got: " + String.valueOf(cop));
                    }
                    ExprList el = f.getExprs();
                    conditions.add(el);
                    boolean isUnitTable = ObjectUtils.tryCastAs(OpTable.class, (Object)f.getSubOp()).map(t -> t.isJoinIdentity()).orElse(false);
                    Preconditions.checkArgument((boolean)isUnitTable, (Object)"Filters must only have unit tables as sub ops");
                }
                if (conditions.isEmpty()) {
                    conditions.add(new ExprList((Expr)NodeValue.TRUE));
                }
                Preconditions.checkArgument(((pattern = args.get((Object)PATTERN)).size() == 1 ? 1 : 0) != 0, (Object)("Exactly 1 <pattern:> element expected in distinct: - got: " + String.valueOf(pattern)));
                Op subOp = (Op)pattern.iterator().next();
                r = QC.execute((Op)subOp, (Binding)binding, (ExecutionContext)execCxt);
                r = new QueryIterDistinctConditional((QueryIterator)r, null, execCxt, (Collection<ExprList>)conditions);
            } else {
                r = chain.createExecution(opExecute, opOriginal, binding, execCxt);
            }
            return r;
        });
    }
}

