/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.csv;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.sparql.ext.csv.E_CsvParse;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionEval;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.vocabulary.XSD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFunctionFactoryCsvParse
implements PropertyFunctionFactory {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFunctionFactoryCsvParse.class);

    public PropertyFunction create(String uri) {
        return new PropertyFunctionEval(PropFuncArgType.PF_ARG_SINGLE, PropFuncArgType.PF_ARG_EITHER){

            public QueryIterator execEvaluated(Binding parentBinding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCtx) {
                Stream<Object> jsonObjStreamTmp;
                Node object;
                Node rawSubject = argSubject.getArg();
                Node subject = rawSubject.isVariable() ? parentBinding.get((Var)rawSubject) : rawSubject;
                Node options = NodeFactory.createLiteral((String)"");
                if (argObject.isList()) {
                    List argList = argObject.getArgList();
                    int l = argList.size();
                    if (l == 0 || l > 2) {
                        throw new RuntimeException("One or two arguments expected");
                    }
                    object = (Node)argList.get(0);
                    options = l == 2 ? (Node)argList.get(1) : options;
                } else {
                    object = argObject.getArg();
                }
                if (!object.isVariable()) {
                    throw new RuntimeException("Object of csv parsing must be a variable");
                }
                Var outputVar = (Var)object;
                Reader reader = null;
                InputStream in = null;
                if (subject.isLiteral()) {
                    boolean isString = subject.getLiteralDatatype().getURI().equals(XSD.xstring.getURI());
                    if (isString) {
                        String str = subject.getLiteralValue().toString();
                        reader = new StringReader(str);
                    }
                } else if (subject.isURI()) {
                    try {
                        String str = subject.getURI();
                        URI uri = new URI(str);
                        URL url = uri.toURL();
                        in = url.openStream();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    reader = new InputStreamReader(in);
                }
                String optionStr = options.getLiteralValue().toString();
                try {
                    jsonObjStreamTmp = E_CsvParse.parseCsv(reader, optionStr);
                }
                catch (IOException e) {
                    logger.warn("Failed to process csv input", (Throwable)e);
                    jsonObjStreamTmp = Collections.emptySet().stream();
                }
                Stream<JsonElement> jsonObjStream = jsonObjStreamTmp;
                QueryIterator result = QueryIterPlainWrapper.create((Iterator)Iter.onClose(jsonObjStream.map(JenaJsonUtils::createLiteralByValue).map(n -> BindingFactory.binding((Binding)parentBinding, (Var)outputVar, (Node)n)).iterator(), jsonObjStream::close));
                return result;
            }
        };
    }
}

