/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.json;

import com.google.gson.JsonElement;
import org.aksw.jena_sparql_api.sparql.ext.json.RDFDatatypeJson;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;

public class NodeValueJson
extends NodeValue {
    protected JsonElement jsonElement;

    public NodeValueJson(JsonElement jsonElement) {
        this.jsonElement = jsonElement;
    }

    public NodeValueJson(JsonElement jsonElement, Node n) {
        super(n);
        this.jsonElement = jsonElement;
    }

    public JsonElement getJsonElement() {
        return this.jsonElement;
    }

    protected Node makeNode() {
        return NodeFactory.createLiteralByValue((Object)this.jsonElement, (RDFDatatype)RDFDatatypeJson.get());
    }

    public String asString() {
        return this.toString();
    }

    public String toString() {
        String result = this.getNode() != null ? super.asString() : RDFDatatypeJson.get().unparse(this.jsonElement);
        return result;
    }

    public void visit(NodeValueVisitor visitor) {
    }
}

