/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.fs;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;

public class NodeValuePathUtils {
    public static Path toPath(NodeValue v) {
        Path result;
        block4: {
            try {
                if (v.isIRI()) {
                    String iri = v.asNode().getURI();
                    result = Paths.get(new URI(iri));
                    break block4;
                }
                if (v.isString()) {
                    String pathStr = v.getString();
                    result = Paths.get(pathStr, new String[0]);
                    break block4;
                }
                throw new ExprEvalException("IRI or String expected - got: " + String.valueOf(v));
            }
            catch (Exception e) {
                throw new ExprEvalException("Failed to create path from " + String.valueOf(v));
            }
        }
        return result;
    }
}

