/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.collection.base;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.aksw.jena_sparql_api.rdf.collections.NodeMapperFromRdfDatatype;
import org.aksw.jena_sparql_api.sparql.ext.util.PropFuncArgUtils;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.arq.util.node.NodeCollection;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;

public class PF_CollectionUnnest
extends PropertyFunctionBase {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        boolean isArray;
        Node node = BindingUtils.getValue((Binding)binding, (Node)argSubject.getArg());
        List<Node> objects = PropFuncArgUtils.getAsList(argObject);
        Node object = objects.get(0);
        Node indexKey = objects.size() > 1 ? objects.get(1) : null;
        Node index = BindingUtils.getValue((Binding)binding, (Node)indexKey, (Node)indexKey);
        Var indexVarTmp = null;
        Integer indexVal = null;
        if (index != null) {
            if (index.isVariable()) {
                indexVarTmp = (Var)index;
            } else {
                if (!index.isLiteral()) throw new ExprEvalException("Index into node array is not a number " + String.valueOf(index));
                Object obj = NodeMapperFromRdfDatatype.toJavaCore((Node)index, (RDFDatatype)index.getLiteralDatatype());
                if (!(obj instanceof Number)) throw new ExprEvalException("Index into node array is a literal but not a number: " + String.valueOf(index));
                indexVal = ((Number)obj).intValue();
            }
        }
        Var indexVar = indexVarTmp;
        QueryIterator result = null;
        boolean bl = isArray = node != null && node.isLiteral() && node.getLiteralValue() instanceof NodeCollection;
        if (isArray) {
            void var17_20;
            NodeCollection arr = (NodeCollection)node.getLiteralValue();
            if (indexVal != null) {
                Binding b = PF_CollectionUnnest.itemToBinding(binding, arr, indexVal, indexVar, object);
                Iterator iterator = b == null ? Collections.emptyIterator() : Collections.singleton(b).iterator();
            } else {
                Iterator iterator = IntStream.range(0, arr.size()).mapToObj(i -> {
                    Binding r = PF_CollectionUnnest.itemToBinding(binding, arr, i, indexVar, object);
                    return r;
                }).filter(Objects::nonNull).iterator();
            }
            result = QueryIterPlainWrapper.create((Iterator)var17_20, (ExecutionContext)execCxt);
        }
        if (result != null) return result;
        return QueryIterNullIterator.create((ExecutionContext)execCxt);
    }

    public static Binding itemToBinding(Binding binding, NodeCollection arr, int i, Var indexVar, Node output) {
        Node item;
        try {
            item = (Node)Iterables.get((Iterable)arr, (int)i);
        }
        catch (Exception e) {
            throw new ExprEvalException((Throwable)e);
        }
        if (item != null && output != null) {
            if (output.isVariable()) {
                Var v = (Var)output;
                binding = BindingFactory.binding((Binding)binding, (Var)v, (Node)item);
            } else if (!Objects.equals(item, output)) {
                binding = null;
            }
        }
        if (binding != null && indexVar != null) {
            binding = BindingFactory.binding((Binding)binding, (Var)indexVar, (Node)NodeValue.makeInteger((long)i).asNode());
        }
        return binding;
    }
}

