/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import com.uber.h3core.H3Core;
import com.uber.h3core.util.LatLng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.H3CellToChildrenPF;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.H3GeometryToCellIDsPF;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.H3GridDiskPF;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.H3ToGeometryAgg;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.arq.functionbinder.FunctionBinder;
import org.aksw.jenax.arq.util.node.NodeList;
import org.aksw.jenax.arq.util.node.NodeListImpl;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.GeometryWrapperFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.utils.H3Utils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaExtensionsH3 {
    private static final Logger logger = LoggerFactory.getLogger(JenaExtensionsH3.class);
    public static final String NS = "https://w3id.org/aksw/norse#h3.";
    private static final H3Core h3 = JenaExtensionsH3.getOrNull();

    public static H3Core getOrNull() {
        H3Core result;
        try {
            result = H3Core.newInstance();
        }
        catch (IOException e) {
            result = null;
            logger.warn("Failed to initialize uber's H3 spatial grid library. Functionality will not be available", (Throwable)e);
        }
        return result;
    }

    public static void init(FunctionBinder binder, PropertyFunctionRegistry ppfRegistry) {
        JenaExtensionsH3.initFunctions(binder);
        JenaExtensionsH3.initPropertyFunctions(ppfRegistry);
    }

    public static void initFunctions(FunctionBinder binder) {
        try {
            JenaExtensionsH3.initCore(binder);
        }
        catch (Exception e) {
            logger.warn("Error while initializing H3 - some functionality will be unavailable", (Throwable)e);
        }
    }

    public static void initPropertyFunctions(PropertyFunctionRegistry ppfRegistry) {
        ppfRegistry.put("https://w3id.org/aksw/norse#h3.geomToCells", H3GeometryToCellIDsPF.class);
        ppfRegistry.put("https://w3id.org/aksw/norse#h3.cellToChildren", H3CellToChildrenPF.class);
        ppfRegistry.put("https://w3id.org/aksw/norse#h3.gridDisk", H3GridDiskPF.class);
        ppfRegistry.put("http://www.opengis.net/ont/geosparql#h3_geometryToCellIds", H3GeometryToCellIDsPF.class);
        ppfRegistry.put("http://www.opengis.net/ont/geosparql#h3_cellIdToChildren", H3CellToChildrenPF.class);
        ppfRegistry.put("http://www.opengis.net/ont/geosparql#h3_gridDisk", H3GridDiskPF.class);
    }

    public static void initCore(FunctionBinder binder) throws NoSuchMethodException, SecurityException {
        binder.register("https://w3id.org/aksw/norse#h3.latLngToCell", H3Core.class.getMethod("latLngToCell", Double.TYPE, Double.TYPE, Integer.TYPE), (Object)h3);
        binder.register("https://w3id.org/aksw/norse#h3.latLngToCellAddress", H3Core.class.getMethod("latLngToCellAddress", Double.TYPE, Double.TYPE, Integer.TYPE), (Object)h3);
        binder.registerAll(JenaExtensionsH3.class);
    }

    @Iri(value="https://w3id.org/aksw/norse#h3.cellToPolygon")
    public static GeometryWrapper cellToPolygon(long addr) {
        List latlngs = h3.cellToBoundary(addr);
        List<Coordinate> coords = JenaExtensionsH3.h3ToJts(latlngs);
        coords.add(coords.get(0));
        GeometryWrapper result = GeometryWrapperFactory.createPolygon(coords, (String)"http://www.opengis.net/ont/geosparql#wktLiteral");
        return result;
    }

    public static Coordinate h3ToJts(LatLng latLng) {
        return new Coordinate(latLng.lng, latLng.lat);
    }

    public static List<Coordinate> h3ToJts(List<LatLng> latLngs) {
        return latLngs.stream().map(JenaExtensionsH3::h3ToJts).collect(Collectors.toCollection(() -> new ArrayList(latLngs.size())));
    }

    @Iri(value="https://w3id.org/aksw/norse#h3.cells")
    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static NodeList h3CellIDs(GeometryWrapper geomWrapper, int level, boolean fullCover) {
        Long[] ids = Functions.h3CellIDs((Geometry)geomWrapper.getParsingGeometry(), (int)level, (boolean)fullCover);
        NodeListImpl nodeList = new NodeListImpl(Arrays.stream(ids).map(NodeFactoryExtra::intToNode).collect(Collectors.toList()));
        return nodeList;
    }

    @Iri(value="https://w3id.org/aksw/norse#h3.lonLatToCell")
    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static long h3LongLatAsCellId(double lon, double lat, int resolution) {
        long cellId = H3Utils.h3.latLngToCell(lat, lon, resolution);
        return cellId;
    }

    @Iri(value="https://w3id.org/aksw/norse#h3.cellToGeom")
    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static GeometryWrapper h3CellIdToGeom(long cellId) {
        Geometry geom = H3ToGeometryAgg.h3ToGeom(new long[]{cellId});
        return GeometryWrapperFactory.createGeometry((Geometry)geom, (String)"http://www.opengis.net/ont/geosparql#wktLiteral");
    }

    @Iri(value="https://w3id.org/aksw/norse#h3.cellToParent")
    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static long h3CellIdToParent(long cellId, int parentRes) {
        long parentId = H3Utils.h3.cellToParent(cellId, parentRes);
        return parentId;
    }

    @Iri(value="https://w3id.org/aksw/norse#h3.isValidCell")
    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static boolean h3IsValidCell(long cellId) {
        return H3Utils.h3.isValidCell(cellId);
    }

    @Iri(value="https://w3id.org/aksw/norse#h3.resolution")
    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static int h3CellResolution(long cellId) {
        return H3Utils.h3.getResolution(cellId);
    }

    @Iri(value="https://w3id.org/aksw/norse#h3.gridDistance")
    @IriNs(value="http://www.opengis.net/def/function/geosparql/")
    public static long h3GridDistance(long cellId1, long cellId2) {
        return H3Utils.h3.gridDistance(cellId1, cellId2);
    }
}

