/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import org.aksw.commons.rx.lookup.MapPaginator;
import org.aksw.commons.rx.lookup.MapService;
import org.aksw.jena_sparql_api.lookup.MapPaginatorConcept;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.DataServiceBBoxCache;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoConstraintFactory;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoConstraintFactoryWgs;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.vocabulary.XSD;
import org.locationtech.jts.geom.Envelope;

public class MapServiceBBox
implements MapService<Envelope, Node, Node> {
    protected RDFDataSource dataSource;
    protected GeoConstraintFactory geoConstraintFactory;
    protected Fragment1 concept;

    public MapServiceBBox(RDFDataSource dataSource, Fragment1 concept, GeoConstraintFactory geoConstraintFactory) {
        this.dataSource = dataSource;
        this.concept = concept;
        this.geoConstraintFactory = geoConstraintFactory;
    }

    public MapPaginator<Node, Node> createPaginator(Envelope bounds) {
        Fragment geoFragment = this.geoConstraintFactory.getFragment();
        if (bounds != null) {
            Expr expr = this.geoConstraintFactory.createExpr(bounds);
            geoFragment = geoFragment.filter(expr);
        }
        Var idVar = this.geoConstraintFactory.getIdVar();
        Fragment1 combined = geoFragment.prependOn(new Var[]{idVar}).with(this.concept).project(new Var[]{idVar}).toFragment1();
        return new MapPaginatorConcept(this.dataSource.asQef(), combined);
    }

    public static void main(String[] args) {
        RDFDataSource ds = RDFDataSources.of((Dataset)RDFDataMgr.loadDataset((String)"/home/raven/Datasets/coypu/events.coypu.10000.ttl"));
        System.out.println("data loaded.");
        Fragment1 concept = ConceptUtils.createSubjectConcept();
        GeoConstraintFactoryWgs gcf = GeoConstraintFactoryWgs.of("https://schema.coypu.org/global#hasLatitude", "https://schema.coypu.org/global#hasLongitude", XSD.xfloat.getURI());
        MapServiceBBox mapService = new MapServiceBBox(ds, concept, gcf);
        Envelope bounds = new Envelope(1.0, 65.0, 1.0, 75.0);
        DataServiceBBoxCache service = new DataServiceBBoxCache(mapService, 1000L, 100L, 2);
        service.runWorkflow(bounds).forEach(x -> {
            System.out.println(x);
            System.out.println(x.getData());
        });
    }
}

