/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import com.google.maps.internal.PolylineEncoding;
import com.google.maps.model.LatLng;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.WKTDatatype;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class F_ParsePolyline
extends FunctionBase1 {
    protected GeometryFactory geometryFactory;

    public F_ParsePolyline() {
        this(CustomGeometryFactory.theInstance());
    }

    public F_ParsePolyline(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public static Coordinate convert(LatLng ll) {
        return new Coordinate(ll.lng, ll.lat);
    }

    public static Coordinate[] convertAll(Collection<LatLng> ll) {
        Coordinate[] result = ll.stream().map(F_ParsePolyline::convert).collect(Collectors.toList()).toArray(new Coordinate[0]);
        return result;
    }

    public NodeValue exec(NodeValue v) {
        if (v != null && v.isString()) {
            String str = v.getString();
            List lls = PolylineEncoding.decode((String)str);
            Coordinate[] coords = F_ParsePolyline.convertAll(lls);
            LineString geom = this.geometryFactory.createLineString(coords);
            GeometryWrapper gw = new GeometryWrapper((Geometry)geom, "http://www.opengis.net/ont/geosparql#wktLiteral");
            Node node = NodeFactory.createLiteralByValue((Object)gw, (RDFDatatype)WKTDatatype.INSTANCE);
            NodeValue result = NodeValue.makeNode((Node)node);
            return result;
        }
        throw new ExprEvalException("ParsePolyline requires string argument");
    }
}

