/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.url;

import com.google.common.io.CharStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.aksw.commons.beans.model.PropertyUtils;
import org.aksw.commons.util.gson.GsonUtils;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.aksw.jena_sparql_api.sparql.ext.json.RDFDatatypeJson;
import org.aksw.jena_sparql_api.sparql.ext.url.JenaUrlUtils;
import org.aksw.jena_sparql_api.sparql.ext.url.UrlFetchSpec;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E_UrlFetch
extends FunctionBase {
    private static final Logger logger = LoggerFactory.getLogger(E_UrlFetch.class);
    public static final Pattern jsonContentTypePattern = Pattern.compile("^[^/]*/([^;+]+\\+)*json\\s*(;.*)?$");

    public NodeValue exec(List<NodeValue> args, FunctionEnv env) {
        NodeValue result;
        block16: {
            JsonObject obj = E_UrlFetch.assemble(args);
            UrlFetchSpec conf = (UrlFetchSpec)RDFDatatypeJson.get().getGson().fromJson((JsonElement)obj, UrlFetchSpec.class);
            try {
                URLConnection conn = E_UrlFetch.configure(conf, env);
                String body = conf.getBody();
                if (body != null) {
                    conn.setDoOutput(true);
                    try (OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
                        out.write(body);
                        ((Writer)out).flush();
                    }
                }
                String contentType = conn.getContentType();
                try (InputStream in = conn.getInputStream();){
                    if (in != null) {
                        String str = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
                        result = jsonContentTypePattern.matcher(contentType).find() ? JenaJsonUtils.fromString(str) : NodeValue.makeString((String)str);
                        break block16;
                    }
                    throw new ExprEvalException("Failed to execute request");
                }
            }
            catch (Exception e) {
                logger.warn("Exception during evaluation of url:fetch with effective spec " + String.valueOf(obj), (Throwable)e);
                throw new ExprEvalException((Throwable)e);
            }
        }
        return result;
    }

    public NodeValue exec(List<NodeValue> args) {
        throw new IllegalStateException("should never be called");
    }

    public void checkBuild(String uri, ExprList args) {
    }

    public static JsonObject assemble(List<NodeValue> args) {
        int n = args.size();
        JsonObject result = new JsonObject();
        for (int i = 0; i < n; ++i) {
            NodeValue v;
            NodeValue k = args.get(i);
            NodeValue nodeValue = v = i + 1 < n ? args.get(i + 1) : null;
            if (k.isString()) {
                if (i == 0) {
                    result.addProperty("url", k.asString());
                    continue;
                }
                String keyStr = k.getString();
                List key = GsonUtils.parsePathSegments((String)keyStr);
                E_UrlFetch.expandShortcuts(key);
                if (v != null) {
                    JsonElement elt = JenaJsonUtils.enforceJsonElement(v);
                    GsonUtils.setElement((JsonObject)result, (List)key, (JsonElement)elt);
                }
                ++i;
                continue;
            }
            if (JenaJsonUtils.isJsonElement(k)) {
                JsonElement elt = JenaJsonUtils.extractJsonElementOrNull(k);
                GsonUtils.merge((JsonElement)result, (JsonElement)elt);
                continue;
            }
            throw new ExprTypeException("Either JSON or string type expected for argument " + i);
        }
        return result;
    }

    public static void expandShortcuts(List<String> key) {
        int n = key.size();
        if (n >= 1) {
            String first = key.get(0);
            if (n > 1) {
                if (first.equals("h")) {
                    key.set(0, "headers");
                }
            } else if (n == 1) {
                if (first.equals("m")) {
                    key.set(0, "method");
                } else if (first.equals("b")) {
                    key.set(0, "body");
                } else if (first.equals("cto")) {
                    key.set(0, "connectTimeout");
                } else if (first.equals("rto")) {
                    key.set(0, "readTimeout");
                }
            }
        }
    }

    public static URLConnection configure(UrlFetchSpec conf, FunctionEnv env) throws IOException {
        String urlStr = conf.getUrl();
        URL url = new URL(urlStr);
        JenaUrlUtils.validate(url, env.getContext());
        URLConnection result = url.openConnection();
        E_UrlFetch.configure(result, conf);
        return result;
    }

    public static void configure(URLConnection conn, UrlFetchSpec conf) {
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection c = (HttpURLConnection)conn;
            PropertyUtils.applyIfPresent(c::setRequestMethod, conf::getMethod);
            PropertyUtils.applyIfPresent(c::setConnectTimeout, conf::getConnectTimeout);
            PropertyUtils.applyIfPresent(c::setReadTimeout, conf::getReadTimeout);
            for (Map.Entry<String, String> e : conf.getHeaders().entrySet()) {
                c.setRequestProperty(e.getKey(), e.getValue());
            }
        }
    }
}

