/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.http;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;

public class HttpInterceptorRdfLogging
implements HttpRequestInterceptor,
HttpResponseInterceptor {
    private Sink<Model> modelSink;

    public HttpInterceptorRdfLogging(Sink<Model> modelSink) {
        this.modelSink = modelSink;
    }

    public static HttpRequest unwrap(HttpRequest result) {
        if (result instanceof RequestWrapper) {
            HttpRequest tmp = ((RequestWrapper)result).getOriginal();
            result = tmp == null ? result : HttpInterceptorRdfLogging.unwrap(tmp);
        }
        return result;
    }

    public static void writeHttpLogMsg(Model target, Resource root) {
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Stopwatch sw = Stopwatch.createStarted();
        HttpRequest orig = HttpInterceptorRdfLogging.unwrap(request);
        if (orig instanceof HttpRequestBase) {
            HttpRequestBase httpRequestBase = (HttpRequestBase)orig;
        }
        context.setAttribute("stopwatch", (Object)sw);
        context.setAttribute("request", (Object)orig);
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequestBase orig = (HttpRequestBase)context.getAttribute("request");
        URI uri = orig.getURI();
        String uriStr = uri.toString();
        if (!uriStr.contains("log")) {
            Stopwatch sw = (Stopwatch)context.getAttribute("stopwatch");
            int statusCode = response.getStatusLine().getStatusCode();
            long requestDuration = sw.elapsed(TimeUnit.MILLISECONDS);
            Model m = ModelFactory.createDefaultModel();
            String prefix = "http://example.org/log/";
            Resource s = m.createResource(prefix + "msg-" + System.nanoTime());
            String http = "http://jsa.aksw.org/ontology/http/";
            String u = "http://jsa.aksw.org/ontology/uri/";
            m.add(s, RDF.type, http + "Message");
            m.add(s, m.createProperty(u + "uri"), uri.toString());
            m.add(s, m.createProperty(u + "scheme"), uri.getScheme());
            m.add(s, m.createProperty(u + "host"), uri.getHost());
            m.add(s, m.createProperty(u + "path"), uri.getPath());
            m.add(s, m.createProperty(u + "port"), (RDFNode)m.createTypedLiteral(uri.getPort()));
            m.add(s, m.createProperty(u + "fragment"), (String)StringUtils.defaultIfEmpty((CharSequence)uri.getFragment(), (CharSequence)""));
            m.add(s, m.createProperty(u + "authority"), uri.getAuthority());
            m.add(s, DCTerms.created, (RDFNode)m.createTypedLiteral((Calendar)new GregorianCalendar()));
            m.add(s, m.createProperty(http + "duration"), (RDFNode)m.createTypedLiteral(requestDuration));
            m.add(s, m.createProperty(http + "statusCode"), (RDFNode)m.createTypedLiteral(statusCode));
            this.modelSink.send((Object)m);
        }
    }
}

