/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.url;

import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import org.aksw.jenax.arq.util.security.ArqSecurity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaUrlUtils {
    private static final Logger logger = LoggerFactory.getLogger(JenaUrlUtils.class);
    public static final Symbol symContentBaseIriX = SystemARQ.allocSymbol((String)"contentBaseIriX");

    public static void validate(URL url, Context cxt) {
        if (url != null && url.getProtocol().equals("file")) {
            ArqSecurity.requireFileAccess((Context)cxt);
        }
    }

    public static Prologue getCurrentPrologue(Context cxt) {
        Prologue result = (Prologue)cxt.get(ARQConstants.sysCurrentQuery);
        return result;
    }

    public static IRIx getContextBaseIriX(Context cxt) {
        IRIx result = (IRIx)cxt.get(symContentBaseIriX);
        if (result == null) {
            result = Optional.ofNullable(JenaUrlUtils.getCurrentPrologue(cxt)).map(Prologue::getBase).orElse(null);
        }
        return result;
    }

    public static IRIx extractBaseIriX(FunctionEnv env) {
        IRIx result = Optional.ofNullable(env).map(FunctionEnv::getContext).map(JenaUrlUtils::getContextBaseIriX).orElse(null);
        return result;
    }

    public static IRIx createIriX(NodeValue nv, FunctionEnv env) {
        String url;
        IRIx result = null;
        if (nv.isString()) {
            url = nv.getString();
        } else if (nv.isIRI()) {
            Node node = nv.asNode();
            url = node.getURI();
        } else {
            url = null;
        }
        if (url != null) {
            IRIxResolver.Builder builder = IRIxResolver.create().allowRelative(true);
            IRIx base = JenaUrlUtils.extractBaseIriX(env);
            builder.base(base);
            IRIxResolver resolver = builder.build();
            result = resolver.resolve(url);
        }
        return result;
    }

    public static InputStream openInputStream(NodeValue nv, FunctionEnv env) throws Exception {
        return JenaUrlUtils.openInputStream(nv, env, null);
    }

    public static InputStream openInputStream(NodeValue nv, FunctionEnv env, Path baseDir) throws Exception {
        URLConnection conn = JenaUrlUtils.openUrlConnection(nv, env, baseDir);
        InputStream result = conn == null ? null : conn.getInputStream();
        return result;
    }

    public static URLConnection openUrlConnection(NodeValue nv, FunctionEnv env, Path baseDir) throws Exception {
        URLConnection result = null;
        IRIx irix = JenaUrlUtils.createIriX(nv, env);
        if (irix != null) {
            URL u;
            String urlStr = irix.str();
            URI uri = new URI(urlStr);
            String scheme = uri.getScheme();
            if (scheme == null) {
                if (!urlStr.startsWith("/")) {
                    Path cwd = baseDir != null ? baseDir : Path.of("", new String[0]);
                    uri = cwd.resolve(urlStr).toUri();
                } else {
                    String fileUrl = "file://" + urlStr;
                    uri = new URI(fileUrl);
                }
            }
            try {
                u = uri.toURL();
                JenaUrlUtils.validate(u, env.getContext());
            }
            catch (Exception e) {
                String msg = "Failed to create URL from " + String.valueOf(uri);
                logger.warn(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
            result = u.openConnection();
        }
        return result;
    }

    public static NodeValue resolve(NodeValue nv, FunctionEnv env) throws Exception {
        return JenaUrlUtils.resolve(nv, env, null);
    }

    public static NodeValue resolve(NodeValue nv, FunctionEnv env, Path baseDir) throws Exception {
        NodeValue result;
        block7: {
            try (InputStream in = JenaUrlUtils.openInputStream(nv, env, baseDir);){
                if (in != null) {
                    String str = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
                    result = NodeValue.makeString((String)str);
                    break block7;
                }
                throw new ExprEvalException("Failed to obtain text from node " + String.valueOf(nv));
            }
        }
        return result;
    }

    public static Iterator<NodeValue> resolveAsLines(NodeValue nv, FunctionEnv env) throws Exception {
        return JenaUrlUtils.resolveAsLines(nv, env, null);
    }

    public static Iterator<NodeValue> resolveAsLines(NodeValue nv, FunctionEnv env, Path baseDir) throws Exception {
        LineIterator lineIterator = IOUtils.lineIterator((InputStream)JenaUrlUtils.openInputStream(nv, env, baseDir), (Charset)StandardCharsets.UTF_8);
        return Iter.map((Iterator)lineIterator, NodeValue::makeString);
    }
}

