/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.sys;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aksw.jenax.arq.datatype.lambda.Lambda;
import org.aksw.jenax.arq.datatype.lambda.Lambdas;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FN_Retry
extends FunctionBase {
    private static final Logger logger = LoggerFactory.getLogger(FN_Retry.class);

    protected NodeValue exec(List<NodeValue> args, FunctionEnv env) {
        long i;
        int n = args.size();
        NodeValue supplierNv = args.get(0);
        NodeValue predicateNv = args.get(1);
        NodeValue retryCountNv = n > 2 ? args.get(2) : null;
        Context cxt = env.getContext();
        AtomicBoolean cancelSignal = (AtomicBoolean)cxt.get(ARQConstants.symCancelQuery);
        long retryCount = Long.MAX_VALUE;
        if (retryCountNv != null) {
            if (retryCountNv.isInteger()) {
                retryCount = retryCountNv.getInteger().longValue();
            } else {
                NodeValue.raise((ExprException)new ExprEvalTypeException("Expected a long value for the retry count (third argument)"));
            }
        }
        Lambda supplier = Lambdas.extract((NodeValue)supplierNv);
        Lambda predicate = Lambdas.extract((NodeValue)predicateNv);
        if (!supplier.getParams().isEmpty()) {
            throw new RuntimeException("Lambda for supplying values must not accept any arguments");
        }
        if (predicate.getParams().size() != 1) {
            throw new RuntimeException("Lambda for validation values must only accept one argument.");
        }
        NodeValue result = null;
        for (i = 0L; !(i >= retryCount || cancelSignal != null && cancelSignal.get()); ++i) {
            NodeValue verdict;
            NodeValue tmp;
            block10: {
                tmp = Lambdas.eval((Lambda)supplier, List.of(), (FunctionEnv)env);
                verdict = null;
                try {
                    verdict = Lambdas.eval((Lambda)predicate, List.of(tmp), (FunctionEnv)env);
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block10;
                    logger.info("Lambda evaluation raised an exception.", (Throwable)e);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Verdict for {} is {}. Value supplied by {} and evaluated with {}.", new Object[]{tmp, verdict, supplier, predicate});
            }
            if (verdict == null || !Boolean.TRUE.equals(verdict.getBoolean())) continue;
            result = tmp;
            break;
        }
        if (result == null) {
            NodeValue.raise((ExprException)new ExprEvalTypeException("Failed to compute a non-null result after " + i + " retries"));
        }
        return result;
    }

    public NodeValue exec(List<NodeValue> args) {
        throw new UnsupportedOperationException("Should never be called");
    }

    public void checkBuild(String uri, ExprList args) {
        int n = args.size();
        if (n < 2 || n > 3) {
            throw new QueryBuildException("Function '" + Lib.className((Object)((Object)this)) + "' takes two or three arguments");
        }
    }
}

