/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.GeometryWrapperFactory;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import org.locationtech.jts.io.geojson.fork.GeoJsonReader;

public class RDFDatatypeGeoJSON
extends GeometryDatatype {
    public static final String URI = "http://www.opengis.net/ont/geosparql#geoJSONLiteral";
    public static final RDFDatatypeGeoJSON INSTANCE = new RDFDatatypeGeoJSON();

    public static RDFDatatype get() {
        return INSTANCE;
    }

    private RDFDatatypeGeoJSON() {
        super(URI);
    }

    public GeometryWrapper read(String geometryLiteral) {
        try {
            GeoJsonReader reader = new GeoJsonReader();
            Geometry geom = reader.read(geometryLiteral);
            geom = CustomGeometryFactory.theInstance().createGeometry(geom);
            String srid = "http://www.opengis.net/def/crs/OGC/1.3/CRS84";
            GeometryWrapper wrapper = GeometryWrapperFactory.createGeometry((Geometry)geom, (String)srid, (String)URI);
            return wrapper;
        }
        catch (ParseException e) {
            throw new DatatypeFormatException("Not a GeoJSON literal: " + geometryLiteral, (Throwable)e);
        }
    }

    public String unparse(Object geometry) {
        if (geometry instanceof GeometryWrapper) {
            GeometryWrapper gw = (GeometryWrapper)geometry;
            GeoJsonWriter writer = new GeoJsonWriter();
            writer.setForceCCW(true);
            writer.setEncodeCRS(false);
            try {
                GeometryWrapper convertedGeom = gw.transform("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
                String json = writer.write(convertedGeom.getParsingGeometry());
                return json;
            }
            catch (Exception e) {
                throw new ARQInternalErrorException("Failed to write GeoJSON literal: " + String.valueOf(geometry));
            }
        }
        throw new DatatypeFormatException("Object to unparse GeoJSON literal is not a GeometryWrapper");
    }
}

