/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.collector.core.AggBuilder;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.commons.lambda.serializable.SerializableBiFunction;
import org.aksw.commons.lambda.serializable.SerializableConsumer;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.lambda.serializable.SerializablePredicate;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.jena_sparql_api.sparql.ext.util.AccAdapterJena;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.VariableNotBoundException;
import org.apache.jena.sparql.expr.aggregate.AccumulatorFactory;
import org.apache.jena.sparql.function.FunctionEnv;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoSparqlExAggregators {
    private static final Logger logger = LoggerFactory.getLogger(GeoSparqlExAggregators.class);

    public static AccumulatorFactory wrap1(BiFunction<? super Expr, ? super Boolean, ? extends Aggregator<Binding, FunctionEnv, GeometryWrapper>> ctor) {
        return (aggCustom, distinct) -> {
            Expr expr = aggCustom.getExpr();
            Aggregator coreAgg = ((Aggregator)ctor.apply(expr, distinct)).finish((SerializableFunction & Serializable)geometryWrapper -> {
                NodeValue r = geometryWrapper == null ? null : geometryWrapper.asNodeValue();
                return r;
            });
            return new AccAdapterJena((Accumulator<Binding, FunctionEnv, NodeValue>)coreAgg.createAccumulator());
        };
    }

    public static Class<?> getCommonItemType(Iterator<?> it, Class<?> emptyFallback) {
        Class<Object> result = null;
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == null) continue;
            Class<?> clz = obj.getClass();
            if (result == null) {
                result = clz;
                continue;
            }
            if (clz.isAssignableFrom(result)) {
                result = clz;
                continue;
            }
            result = Object.class;
            break;
        }
        if (result == null) {
            result = emptyFallback;
        }
        return result;
    }

    public static Geometry mostSpecificGeometry(Collection<Geometry> geoms, GeometryFactory geomFactory) {
        Class<?> type = GeoSparqlExAggregators.getCommonItemType(geoms.iterator(), null);
        Object result = geoms.isEmpty() || type == null ? geomFactory.createGeometryCollection() : (geoms.size() == 1 ? geoms.iterator().next() : (Polygon.class.isAssignableFrom(type) ? geomFactory.createMultiPolygon(geoms.toArray(new Polygon[0])) : (LineString.class.isAssignableFrom(type) ? geomFactory.createMultiLineString(geoms.toArray(new LineString[0])) : (Point.class.isAssignableFrom(type) ? geomFactory.createMultiPoint(geoms.toArray(new Point[0])) : geomFactory.createGeometryCollection(geoms.toArray(new Geometry[0]))))));
        return result;
    }

    public static ParallelAggregator<Binding, FunctionEnv, GeometryWrapper, ?> aggUnionGeometryWrapperCollection(Expr geomExpr, boolean distinct) {
        GeometryFactory geomFactory = CustomGeometryFactory.theInstance();
        Function<Collection<Geometry>, Geometry> finisher = geoms -> UnaryUnionOp.union((Collection)geoms, (GeometryFactory)geomFactory);
        return GeoSparqlExAggregators.aggGeometryWrapperCollection(geomExpr, distinct, finisher);
    }

    public static ParallelAggregator<Binding, FunctionEnv, GeometryWrapper, ?> aggIntersectionGeometryWrapperCollection(Expr geomExpr, boolean distinct) {
        GeometryFactory geomFactory = CustomGeometryFactory.theInstance();
        Function<Collection<Geometry>, Geometry> finisher = geoms -> {
            Iterator it = geoms.iterator();
            if (it.hasNext()) {
                Geometry intersection = (Geometry)it.next();
                while (it.hasNext()) {
                    intersection = intersection.intersection((Geometry)it.next());
                }
                return intersection;
            }
            return geomFactory.createGeometryCollection();
        };
        return GeoSparqlExAggregators.aggGeometryWrapperCollection(geomExpr, distinct, finisher);
    }

    public static ParallelAggregator<Binding, FunctionEnv, GeometryWrapper, ?> aggGeometryWrapperCollection(Expr geomExpr, boolean distinct) {
        return GeoSparqlExAggregators.aggGeometryWrapperCollection(geomExpr, distinct, false);
    }

    public static ParallelAggregator<Binding, FunctionEnv, GeometryWrapper, ?> aggGeometryWrapperCollection(Expr geomExpr, boolean distinct, boolean unwrapSingle) {
        GeometryFactory geomFactory = CustomGeometryFactory.theInstance();
        Function<Collection<Geometry>, Geometry> finisher = geoms -> unwrapSingle && geoms.size() == 1 ? (Geometry)geoms.iterator().next() : geomFactory.createGeometryCollection(geoms.toArray(new Geometry[0]));
        return GeoSparqlExAggregators.aggGeometryWrapperCollection(geomExpr, distinct, finisher);
    }

    public static ParallelAggregator<Binding, FunctionEnv, GeometryWrapper, ?> aggGeometryWrapperCollection(Expr geomExpr, boolean distinct, Function<Collection<Geometry>, Geometry> finisher) {
        return AggBuilder.errorHandler((ParallelAggregator)AggBuilder.inputTransform2((SerializableBiFunction & Serializable)(b, env) -> {
            try {
                NodeValue nv = geomExpr.eval(b, env);
                return GeometryWrapper.extract((NodeValue)nv);
            }
            catch (VariableNotBoundException variableNotBoundException) {
                return null;
            }
        }, (ParallelAggregator)AggBuilder.inputFilter((SerializablePredicate & Serializable)input -> input != null, GeoSparqlExAggregators.aggGeometryWrapperCollection(distinct, finisher))), (boolean)false, (SerializableConsumer & Serializable)ex -> logger.warn("Error while aggregating a collection of geometries", ex), null);
    }

    public static ParallelAggregator<GeometryWrapper, FunctionEnv, GeometryWrapper, ?> aggGeometryWrapperCollection(boolean distinct, Function<Collection<Geometry>, Geometry> finisher) {
        SerializableSupplier & Serializable collectionSupplier = distinct ? LinkedHashSet::new : ArrayList::new;
        return AggBuilder.outputTransform((ParallelAggregator)AggBuilder.collectionSupplier((SerializableSupplier)collectionSupplier), (SerializableFunction & Serializable)col -> {
            Set srsUris = col.stream().map(GeometryWrapper::getSrsURI).collect(Collectors.toSet());
            Collection geoms = col.stream().map(GeometryWrapper::getParsingGeometry).collect(Collectors.toList());
            Geometry geom = (Geometry)finisher.apply(geoms);
            String srsUri = (String)Iterables.getOnlyElement(srsUris, (Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84");
            GeometryWrapper r = new GeometryWrapper(geom, srsUri, "http://www.opengis.net/ont/geosparql#wktLiteral");
            return r;
        });
    }
}

