/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import java.util.List;
import java.util.Optional;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.locationtech.jts.geom.Envelope;

public class GeoExprUtils {
    public static Expr createExprWgs84Intersects(Var varX, Var varY, Envelope bounds, Node castNode) {
        ExprVar lon = new ExprVar(varX);
        ExprVar lat = new ExprVar(varY);
        if (castNode != null) {
            String fnName = castNode.getURI();
            lon = new E_Function(fnName, new ExprList((Expr)lon));
            lat = new E_Function(fnName, new ExprList((Expr)lat));
        }
        NodeValue xMin = NodeValue.makeDecimal((double)bounds.getMinX());
        NodeValue xMax = NodeValue.makeDecimal((double)bounds.getMaxX());
        NodeValue yMin = NodeValue.makeDecimal((double)bounds.getMinY());
        NodeValue yMax = NodeValue.makeDecimal((double)bounds.getMaxY());
        E_LogicalAnd result = new E_LogicalAnd((Expr)new E_LogicalAnd((Expr)new E_GreaterThanOrEqual((Expr)lon, (Expr)xMin), (Expr)new E_LessThan((Expr)lon, (Expr)xMax)), (Expr)new E_LogicalAnd((Expr)new E_GreaterThanOrEqual((Expr)lat, (Expr)yMin), (Expr)new E_LessThan((Expr)lat, (Expr)yMax)));
        return result;
    }

    public static Expr createExprOgcIntersects(Expr exprVar, Expr geom, String intersectsFnName, String geomFromTextFnName) {
        String ogc = "http://www.opengis.net/rdf#";
        intersectsFnName = Optional.ofNullable(intersectsFnName).orElse(ogc + "intersects");
        geomFromTextFnName = Optional.ofNullable(geomFromTextFnName).orElse(ogc + "geomFromText");
        Expr geomExpr = geom.isConstant() && geom.getConstant().isString() ? new E_Function(geomFromTextFnName, new ExprList(geom)) : geom;
        E_Function result = new E_Function(intersectsFnName, new ExprList(List.of(exprVar, geomExpr)));
        return result;
    }

    public static String boundsToWkt(Envelope bounds) {
        double ax = bounds.getMinX();
        double ay = bounds.getMaxY();
        double bx = bounds.getMaxX();
        double by = bounds.getMinY();
        String result = "POLYGON((" + ax + " " + ay + "," + bx + " " + ay + "," + bx + " " + by + "," + ax + " " + by + "," + ax + " " + ay + "))";
        return result;
    }
}

