/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.benchmark;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.aksw.jenax.dataaccess.sparql.link.common.RDFLinkUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FN_BenchmarkOld
extends FunctionBase1 {
    private static final Logger logger = LoggerFactory.getLogger(FN_BenchmarkOld.class);

    protected NodeValue exec(List<NodeValue> args, FunctionEnv env) {
        Node node = args.get(0).asNode();
        RDFConnection conn = FN_BenchmarkOld.getConnection(env);
        JsonObject json = FN_BenchmarkOld.benchmark(conn, node, false);
        if (json == null) {
            throw new ExprTypeException("no node value obtained");
        }
        NodeValue result = JenaJsonUtils.makeNodeValue((JsonElement)json);
        return result;
    }

    public static JsonObject benchmark(RDFConnection conn, Node node, boolean includeResultSet) {
        JsonObject result;
        if (node.isVariable()) {
            result = null;
        } else {
            NodeValue nv = NodeValue.makeNode((Node)node);
            if (nv.isString()) {
                String queryStr = nv.getString();
                result = FN_BenchmarkOld.benchmark(conn, queryStr, includeResultSet);
            } else {
                throw new ExprTypeException("Incorrect node value type " + String.valueOf(nv));
            }
        }
        return result;
    }

    public static RDFConnection getConnection(ExecutionContext env) {
        RDFConnection conn = null;
        Context cxt = env.getContext();
        if (cxt != null) {
            conn = (RDFConnection)cxt.get(RDFLinkUtils.CONNECTION_SYMBOL);
        }
        if (conn == null) {
            DatasetGraph dsg;
            if (logger.isInfoEnabled()) {
                logger.info("No connection in context, falling back to dataset");
            }
            if ((dsg = env.getDataset()) != null) {
                Dataset ds = DatasetFactory.wrap((DatasetGraph)dsg);
                conn = RDFConnectionFactory.connect((Dataset)ds);
            }
        }
        return conn;
    }

    public static RDFConnection getConnection(FunctionEnv env) {
        RDFConnection conn = null;
        Context cxt = env.getContext();
        if (cxt != null) {
            conn = (RDFConnection)cxt.get(RDFLinkUtils.CONNECTION_SYMBOL);
        }
        if (conn == null) {
            DatasetGraph dsg;
            if (logger.isInfoEnabled()) {
                logger.info("No connection in context, falling back to dataset");
            }
            if ((dsg = env.getDataset()) != null) {
                Dataset ds = DatasetFactory.wrap((DatasetGraph)dsg);
                conn = RDFConnectionFactory.connect((Dataset)ds);
            }
        }
        return conn;
    }

    public static JsonObject benchmark(RDFConnection conn, String queryStr, boolean includeResultSet) {
        if (conn == null) {
            throw new RuntimeException("No connection or dataset specified in context");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Benchmarking query: " + queryStr);
        }
        Stopwatch sw = Stopwatch.createStarted();
        Long resultSetSize = null;
        ResultSetRewindable rsw = null;
        try (QueryExecution qe = conn.query(queryStr);){
            ResultSet rs = qe.execSelect();
            if (includeResultSet) {
                rsw = ResultSetFactory.copyResults((ResultSet)rs);
            } else {
                resultSetSize = ResultSetFormatter.consume((ResultSet)rs);
            }
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failure executing benchmark request", (Throwable)e);
            }
            throw new ExprTypeException("Failure executing benchmark request", (Throwable)e);
        }
        long ms = sw.stop().elapsed(TimeUnit.NANOSECONDS);
        BigDecimal s = new BigDecimal(ms).divide(new BigDecimal(1000000000L));
        JsonObject json = new JsonObject();
        json.addProperty("time", (Number)s);
        if (rsw != null) {
            rsw.reset();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ResultSetFormatter.outputAsJSON((OutputStream)baos, (ResultSet)rsw);
            String resultSetStr = baos.toString();
            resultSetSize = rsw.size();
            Gson gson = new Gson();
            JsonElement el = (JsonElement)gson.fromJson(resultSetStr, JsonElement.class);
            json.add("result", el);
        }
        json.addProperty("size", (Number)resultSetSize);
        return json;
    }

    public NodeValue exec(NodeValue v) {
        throw new RuntimeException("Should not be invoked directly");
    }
}

