/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.jena_sparql_api.sparql.ext.xml.JenaXmlUtils;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.impl.LiteralLabel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFDatatypeXml
extends BaseDatatype {
    public static final RDFDatatypeXml INSTANCE = new RDFDatatypeXml();
    public static final String IRI = "http://www.w3.org/2001/XMLSchema#xml";
    protected ThreadLocal<DocumentBuilder> documentBuilder;

    public static RDFDatatypeXml get() {
        return INSTANCE;
    }

    public static DocumentBuilder createDefaultDocumentBuilder() {
        DocumentBuilder result;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            result = factory.newDocumentBuilder();
            result.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public RDFDatatypeXml() {
        this(RDFDatatypeXml::createDefaultDocumentBuilder);
    }

    public RDFDatatypeXml(Supplier<DocumentBuilder> documentBuilderSupplier) {
        this(IRI, documentBuilderSupplier);
    }

    public RDFDatatypeXml(String uri, Supplier<DocumentBuilder> documentBuilderSupplier) {
        super(uri);
        this.documentBuilder = ThreadLocal.withInitial(documentBuilderSupplier);
    }

    public Class<?> getJavaClass() {
        return Node.class;
    }

    public boolean isValidValue(Object valueForm) {
        boolean isValid = valueForm instanceof Node;
        return isValid;
    }

    public String unparse(Object value) {
        Node node = (Node)value;
        String result = JenaXmlUtils.toString(node);
        return result;
    }

    public Node parse(String lexicalForm) throws DatatypeFormatException {
        Document result;
        try {
            result = this.documentBuilder.get().parse(new InputSource(new StringReader(lexicalForm)));
        }
        catch (IOException | SAXException e) {
            throw new DatatypeFormatException(lexicalForm, (RDFDatatype)this, (Throwable)e);
        }
        return result;
    }

    public int getHashCode(LiteralLabel lit) {
        String lexicalForm = lit.getLexicalForm();
        int result = lexicalForm.hashCode();
        return result;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder.get();
    }
}

