/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.geosparql.implementation.GeometryWrapperFactory;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorFactory;
import org.apache.jena.sparql.expr.aggregate.AggCustom;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.sedona.common.utils.H3Utils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class H3ToGeometryAgg {
    static AccumulatorFactory h3CellIdAccumulatorFactory = new AccumulatorFactory(){

        public Accumulator createAccumulator(AggCustom agg, boolean distinct) {
            return new H3CellIdAccumulator(agg);
        }
    };

    public static Geometry h3ToGeom(long[] cells) {
        GeometryFactory geomFactory = CustomGeometryFactory.theInstance();
        Collection h3 = Arrays.stream(cells).boxed().collect(Collectors.toList());
        return geomFactory.createMultiPolygon((Polygon[])H3Utils.h3.cellsToMultiPolygon(h3, true).stream().map(shellHoles -> {
            List<LinearRing> rings = shellHoles.stream().map(shell -> geomFactory.createLinearRing((Coordinate[])shell.stream().map(latLng -> new Coordinate(latLng.lng, latLng.lat)).toArray(Coordinate[]::new))).collect(Collectors.toList());
            LinearRing shell2 = (LinearRing)rings.remove(0);
            if (rings.isEmpty()) {
                return geomFactory.createPolygon(shell2);
            }
            return geomFactory.createPolygon(shell2, rings.toArray(new LinearRing[0]));
        }).toArray(Polygon[]::new));
    }

    static class H3CellIdAccumulator
    implements Accumulator {
        List<Long> cellIds = new ArrayList<Long>();
        private AggCustom agg;

        H3CellIdAccumulator(AggCustom agg) {
            this.agg = agg;
        }

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ExprList exprList = this.agg.getExprList();
            for (Expr expr : exprList) {
                try {
                    NodeValue nv = expr.eval(binding, functionEnv);
                    if (!nv.isLiteral()) continue;
                    this.cellIds.add(nv.getInteger().longValue());
                }
                catch (ExprEvalException exprEvalException) {}
            }
        }

        public NodeValue getValue() {
            Geometry geom = H3ToGeometryAgg.h3ToGeom(this.cellIds.stream().mapToLong(Long::longValue).toArray());
            return GeometryWrapperFactory.createGeometry((Geometry)geom, (String)"http://www.opengis.net/ont/geosparql#wktLiteral").asNodeValue();
        }
    }
}

