/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.url;

import java.net.URI;
import java.nio.file.Paths;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;

public class E_UrlNormalize
extends FunctionBase1 {
    public NodeValue exec(NodeValue nv) {
        Node n = nv.asNode();
        if (!n.isURI()) {
            throw new ExprTypeException("Not a URI: " + String.valueOf(nv));
        }
        String str = n.getURI();
        String tmp = E_UrlNormalize.normalize(str);
        NodeValue result = NodeValue.makeNode((Node)NodeFactory.createURI((String)tmp));
        return result;
    }

    public static String normalize(String str) {
        URI uri;
        try {
            uri = new URI(str);
        }
        catch (Exception e) {
            throw new ExprTypeException("Failed to parse URI", (Throwable)e);
        }
        String uriScheme = uri.getScheme();
        String tmp = uriScheme.equals("file") ? Paths.get(uri).normalize().toUri().toString() : uri.normalize().toString();
        return tmp;
    }
}

