/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;

public class E_JsonGet
extends FunctionBase2 {
    public NodeValue exec(NodeValue nv, NodeValue key) {
        JsonElement elt = JenaJsonUtils.requireJsonElement(nv);
        NodeValue result = null;
        if (key.isInteger()) {
            int idx = key.getInteger().intValue();
            if (elt.isJsonArray()) {
                JsonArray arr = elt.getAsJsonArray();
                JsonElement item = arr.get(idx);
                result = JenaJsonUtils.convertJsonToNodeValue(item);
            } else {
                NodeValue.raise((ExprException)new ExprEvalTypeException("Integer key type can only be used to access JSON array elements"));
            }
        } else if (key.isString()) {
            String str = key.getString();
            if (elt.isJsonObject()) {
                JsonElement val = elt.getAsJsonObject().get(str);
                result = JenaJsonUtils.convertJsonOrValueToNodeValue(val);
            } else {
                NodeValue.raise((ExprException)new ExprEvalTypeException("String key type can only be used to access members of JSON objects"));
            }
        } else {
            NodeValue.raise((ExprException)new ExprEvalTypeException("Json array or object expected"));
        }
        if (result == null) {
            NodeValue.raise((ExprException)new ExprEvalException("Access of JSON object by key returned null value"));
        }
        return result;
    }
}

