/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.benchmark;

import com.google.common.collect.Streams;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.sparql.ext.benchmark.FN_BenchmarkOld;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.util.IterLib;

public class PropertyFunctionFactoryExecSelect
implements PropertyFunctionFactory {
    protected Function<? super Path, ? extends Stream<? extends Path>> fn;

    public PropertyFunction create(String uri) {
        return new PropertyFunctionExecSelect();
    }

    public static class PropertyFunctionExecSelect
    extends PFuncSimpleAndList {
        public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
            QueryIterator result;
            RDFConnection conn = FN_BenchmarkOld.getConnection(execCxt);
            if (subject.isVariable()) {
                result = IterLib.noResults((ExecutionContext)execCxt);
            } else {
                NodeValue nv = NodeValue.makeNode((Node)subject);
                if (nv.isString()) {
                    String queryStr = nv.getString();
                    QueryExecution qe = null;
                    try {
                        qe = conn.query(queryStr);
                        ResultSet rs = qe.execSelect();
                        List resultVars = rs.getResultVars();
                        int numRsVars = resultVars.size();
                        List args = object.getArgList();
                        Iterator it = Streams.stream((Iterator)rs).map(qs -> {
                            BindingBuilder b = BindingFactory.builder((Binding)binding);
                            for (int i = 0; i < args.size(); ++i) {
                                String rsVarName = i < numRsVars ? (String)resultVars.get(i) : null;
                                Node arg = (Node)args.get(i);
                                Node val = Optional.ofNullable(qs.get(rsVarName)).map(FrontsNode::asNode).orElse(null);
                                if (!arg.isVariable() || val == null) continue;
                                b.add((Var)arg, val);
                            }
                            return b.build();
                        }).iterator();
                        result = QueryIterPlainWrapper.create((Iterator)Iter.onClose(it, () -> ((QueryExecution)qe).close()), (ExecutionContext)execCxt);
                    }
                    catch (Exception e) {
                        if (qe != null) {
                            qe.close();
                        }
                        throw new ExprTypeException("Problem encountered", (Throwable)e);
                    }
                } else {
                    throw new ExprTypeException("String argument expected");
                }
            }
            return result;
        }
    }
}

