/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.quadtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class QuadTreeNode<T> {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    protected QuadTreeNode<T> parent;
    protected QuadTreeNode<T>[] children;
    protected final int parentChildIndex;
    protected final Envelope bounds;
    protected final int maxDepth;
    protected final float k;
    protected final int depth;
    protected boolean isLoaded;
    protected Long minItemCount;
    protected long infMinItemCount;
    protected Set<T> data;

    public QuadTreeNode(QuadTreeNode<T> parent, int parentChildIndex, Envelope bounds, int maxDepth, int depth, float k) {
        this.parent = parent;
        this.bounds = bounds;
        this.parentChildIndex = parentChildIndex;
        this.maxDepth = maxDepth;
        this.depth = depth;
        this.k = k;
        this.isLoaded = false;
        this.children = null;
        this.minItemCount = null;
        this.infMinItemCount = 0L;
    }

    public QuadTreeNode<T> getParent() {
        return this.parent;
    }

    public QuadTreeNode<T>[] getChildren() {
        return this.children;
    }

    public Set<T> getData() {
        return this.data == null ? Collections.emptySet() : this.data;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public long getInfMinItemCount() {
        return this.infMinItemCount;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getId() {
        QuadTreeNode<T> parent = this.parent;
        String parentId = parent != null ? parent.getId() : "";
        String indexId = parent != null ? Integer.toString(this.parentChildIndex) : "r";
        String result = parentId + indexId;
        return result;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public void addItem(T item) {
        if (this.data == null) {
            this.data = new LinkedHashSet<T>();
        }
        this.data.add(item);
    }

    public void removeItem(Object id) {
        this.data.remove(id);
    }

    public void setMinItemCount(long value) {
        this.minItemCount = value;
        this.infMinItemCount = value;
        if (this.parent != null) {
            this.parent.updateInfMinItemCount();
        }
    }

    public Long getMinItemCount() {
        return this.minItemCount;
    }

    public boolean isCountComplete() {
        boolean result = false;
        if (this.getMinItemCount() != null && this.children == null) {
            result = true;
        } else if (this.children != null) {
            result = Arrays.asList(this.children).stream().allMatch(QuadTreeNode::isCountComplete);
        }
        return result;
    }

    public void updateInfMinItemCount() {
        if (this.children == null && this.minItemCount != null) {
            return;
        }
        long sum = 0L;
        for (QuadTreeNode<T> child : this.children) {
            if (child.getMinItemCount() != null) {
                sum += child.getMinItemCount().longValue();
                continue;
            }
            sum += child.getMinItemCount().longValue();
        }
        this.infMinItemCount = sum;
        if (this.parent != null) {
            this.parent.updateInfMinItemCount();
        }
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public Coordinate getCenter() {
        return this.bounds.centre();
    }

    public QuadTreeNode<T> newNode(int parentChildIndex, Envelope bounds) {
        return new QuadTreeNode<T>(this.parent, parentChildIndex, bounds, this.maxDepth, this.depth + 1, this.k);
    }

    public void subdivide() {
        Coordinate c = this.getCenter();
        double ew = (double)this.k * 0.5 * this.bounds.getWidth();
        double eh = (double)this.k * 0.5 * this.bounds.getHeight();
        this.children = new QuadTreeNode[4];
        this.children[0] = this.newNode(0, new Envelope(this.bounds.getMinX(), c.x + ew, c.y - eh, this.bounds.getMaxY()));
        this.children[1] = this.newNode(1, new Envelope(c.x - ew, this.bounds.getMaxX(), c.y - eh, this.bounds.getMaxY()));
        this.children[2] = this.newNode(2, new Envelope(this.bounds.getMinX(), c.x + ew, this.bounds.getMinY(), c.y + eh));
        this.children[3] = this.newNode(3, new Envelope(c.x - ew, this.bounds.getMaxX(), this.bounds.getMinY(), c.y + eh));
    }

    public List<QuadTreeNode<T>> query(Envelope bounds, int depth) {
        ArrayList<QuadTreeNode<T>> result = new ArrayList<QuadTreeNode<T>>();
        this.queryRec(bounds, result, depth);
        return result;
    }

    public void queryRec(Envelope queryBounds, Collection<QuadTreeNode<T>> result, int depth) {
        if (!this.bounds.intersects(queryBounds)) {
            return;
        }
        double w = queryBounds.getWidth() / this.bounds.getWidth();
        double h = queryBounds.getHeight() / this.bounds.getHeight();
        double r = Math.max(w, h);
        if (this.isLoaded || this.children == null || r >= (double)depth) {
            result.add(this);
            return;
        }
        for (QuadTreeNode<T> child : this.children) {
            child.queryRec(this.bounds, result, depth);
        }
    }

    public void splitFor(Envelope splitBounds, int depth, Collection<QuadTreeNode<T>> result) {
        double h;
        if (!this.bounds.intersects(splitBounds)) {
            return;
        }
        if (this.isLoaded()) {
            if (result != null) {
                result.add(this);
            }
            return;
        }
        double w = splitBounds.getWidth() / this.bounds.getWidth();
        double r = Math.max(w, h = splitBounds.getHeight() / this.bounds.getHeight());
        if (r >= (double)depth || this.depth >= this.maxDepth) {
            if (result != null) {
                result.add(this);
                System.out.println("Added a node:" + String.valueOf(this.getBounds()) + " - " + this.depth + " - " + r);
            }
            return;
        }
        if (this.children == null) {
            this.subdivide();
        }
        for (int i = 0; i < this.children.length; ++i) {
            QuadTreeNode<T> child = this.children[i];
            child.splitFor(splitBounds, depth, result);
        }
    }

    public Collection<QuadTreeNode<T>> acquireNodes(Envelope splitBounds, int depth) {
        ArrayList<QuadTreeNode<T>> result = new ArrayList<QuadTreeNode<T>>();
        this.splitFor(splitBounds, depth, result);
        return result;
    }

    public void unlink() {
        if (this.parent != null) {
            this.parent.children[this.parentChildIndex] = this.newNode(this.parentChildIndex, this.bounds);
        }
    }

    public String toString() {
        return "QuadTreeNode(" + String.valueOf(this.getBounds()) + ", itemCount: " + this.minItemCount + ", infMinItemCount: " + this.infMinItemCount + ")";
    }
}

