/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.sedona.common.utils.H3Utils;

public class H3CellToChildrenPF
extends PFuncSimpleAndList {
    private static final int CELL_ID_POS = 0;
    private static final int LEVEL_POS = 1;

    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        int cellResolution;
        List objectArgs = argObject.getArgList();
        if (objectArgs.size() != 2) {
            throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": 2 arguments required: cell ID, level of resolution");
        }
        if (!subject.isVariable()) {
            throw new ExprEvalException(FmtUtils.stringForNode((Node)predicate) + ": subject must be variable.");
        }
        Var s = Var.alloc((Node)subject);
        Node cellIdLit = argObject.getArg(0);
        long cellId = NodeValue.makeNode((Node)cellIdLit).getInteger().longValue();
        Node levelNode = argObject.getArg(1);
        NodeValue levelNodeVal = NodeValue.makeNode((Node)levelNode);
        if (!levelNodeVal.isInteger()) {
            throw new ExprEvalException("\"level of resolution\" argument not an integer: " + FmtUtils.stringForNode((Node)levelNodeVal.asNode()));
        }
        int level = levelNodeVal.getInteger().intValue();
        if (level <= (cellResolution = H3Utils.h3.getResolution(cellId))) {
            throw new ExprEvalException(String.format("\"children resolution\" must be greater than cell resolution %d: " + FmtUtils.stringForNode((Node)levelNodeVal.asNode()), cellResolution));
        }
        List childrenIds = H3Utils.h3.cellToChildren(cellId, level);
        Iterator iterator = childrenIds.stream().map(NodeFactoryExtra::intToNode).map(node -> BindingFactory.binding((Binding)binding, (Var)s, (Node)node)).iterator();
        return QueryIterPlainWrapper.create(iterator, (ExecutionContext)execCxt);
    }
}

