/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoExprUtils;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.NodeValue;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class BBoxExprFactoryWkt {
    protected String intersectsFnName;
    protected String geomFromTextFnName;

    public BBoxExprFactoryWkt(String intersectsFnName, String geomFromTextFnName) {
        this.intersectsFnName = intersectsFnName;
        this.geomFromTextFnName = geomFromTextFnName;
    }

    public static BBoxExprFactoryWkt ofGeoSparql() {
        return BBoxExprFactoryWkt.of("http://www.opengis.net/def/function/geosparql/sfIntersects", null);
    }

    public static BBoxExprFactoryWkt of(String intersectsFnName, String geomFromTextFnName) {
        return new BBoxExprFactoryWkt(intersectsFnName, geomFromTextFnName);
    }

    public String getIntersectsFnName() {
        return this.intersectsFnName;
    }

    public String getGeomFromTextFnName() {
        return this.geomFromTextFnName;
    }

    public Expr createExpr(Node var, Envelope envelope) {
        Geometry geom = CustomGeometryFactory.theInstance().toGeometry(envelope);
        return this.createExpr(var, geom);
    }

    public Expr createExpr(Node var, Geometry geom) {
        GeometryWrapper geomWrapper = new GeometryWrapper(geom, "http://www.opengis.net/ont/geosparql#wktLiteral");
        return this.createExpr(var, geomWrapper);
    }

    public Expr createExpr(Node var, GeometryWrapper geom) {
        Node node = geom.asNode();
        return this.createExpr(var, node);
    }

    public Expr createExpr(Node var, Node geom) {
        Expr ev = ExprLib.nodeToExpr((Node)var);
        NodeValue nv = NodeValue.makeNode((Node)geom);
        return this.createExpr(ev, (Expr)nv);
    }

    public Expr createExpr(Expr lhs, Expr geom) {
        return GeoExprUtils.createExprOgcIntersects(lhs, geom, this.intersectsFnName, this.geomFromTextFnName);
    }
}

