/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import java.util.Objects;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.BBoxExprFactoryWkt;
import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeoConstraintFactory;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.WKTDatatype;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.locationtech.jts.geom.Envelope;

public class GeoConstraintFactoryGeoSparql
implements GeoConstraintFactory {
    protected Fragment2 fragment;
    protected BBoxExprFactoryWkt bboxExprFactory;

    protected GeoConstraintFactoryGeoSparql(Fragment2 fragment, BBoxExprFactoryWkt bboxExprFactory) {
        this.fragment = Objects.requireNonNull(fragment);
        this.bboxExprFactory = Objects.requireNonNull(bboxExprFactory);
    }

    public static GeoConstraintFactoryGeoSparql of(String hasGeometryPropertyIri, String asLiteralPropertyIri) {
        Node hasGeometryProperty = NodeFactory.createURI((String)hasGeometryPropertyIri);
        Node asLiteralProperty = NodeFactory.createURI((String)asLiteralPropertyIri);
        return GeoConstraintFactoryGeoSparql.of(hasGeometryProperty, asLiteralProperty);
    }

    public static GeoConstraintFactoryGeoSparql create() {
        return GeoConstraintFactoryGeoSparql.of(Geo.HAS_GEOMETRY_NODE, Geo.AS_WKT_NODE);
    }

    public static GeoConstraintFactoryGeoSparql create2() {
        return GeoConstraintFactoryGeoSparql.of(GeoConstraintFactoryGeoSparql.createFragment(Geo.AS_WKT_NODE));
    }

    public static GeoConstraintFactoryGeoSparql create(String p) {
        return GeoConstraintFactoryGeoSparql.create(NodeFactory.createURI((String)p));
    }

    public static GeoConstraintFactoryGeoSparql create(Node p) {
        return GeoConstraintFactoryGeoSparql.of(GeoConstraintFactoryGeoSparql.createFragment(p));
    }

    public static GeoConstraintFactoryGeoSparql of(Node hasGeometryProperty, Node asLiteralProperty) {
        Fragment2 fragment = GeoConstraintFactoryGeoSparql.createFragment(hasGeometryProperty, asLiteralProperty);
        return GeoConstraintFactoryGeoSparql.of(fragment);
    }

    public static GeoConstraintFactoryGeoSparql of(Fragment2 fragment) {
        return new GeoConstraintFactoryGeoSparql(fragment, BBoxExprFactoryWkt.ofGeoSparql());
    }

    @Override
    public Var getIdVar() {
        return this.fragment.getSourceVar();
    }

    public Fragment2 getFragment() {
        return this.fragment;
    }

    @Override
    public Expr createExpr(Envelope bounds) {
        Var geomVar = this.fragment.getTargetVar();
        Expr result = this.bboxExprFactory.createExpr((Node)geomVar, bounds);
        return result;
    }

    @Override
    public String toWktString(Binding binding) {
        Var geoVar = this.fragment.getTargetVar();
        Node geo = binding.get(geoVar);
        GeometryWrapper geomWrapper = GeometryWrapper.extract((Node)geo);
        String result = WKTDatatype.INSTANCE.unparse((Object)geomWrapper);
        return result;
    }

    public static Fragment2 createFragment(Node asLiteralProperty) {
        ElementTriplesBlock elt = ElementUtils.createElementTriple((Triple[])new Triple[]{Triple.create((Node)Vars.s, (Node)asLiteralProperty, (Node)Vars.g)});
        Fragment2Impl result = new Fragment2Impl((Element)elt, Vars.s, Vars.g);
        return result;
    }

    public static Fragment2 createFragment(Node hasGeometryProperty, Node asLiteralProperty) {
        ElementTriplesBlock elt = ElementUtils.createElementTriple((Triple[])new Triple[]{Triple.create((Node)Vars.s, (Node)hasGeometryProperty, (Node)Vars.x), Triple.create((Node)Vars.s, (Node)asLiteralProperty, (Node)Vars.g)});
        Fragment2Impl result = new Fragment2Impl((Element)elt, Vars.s, Vars.g);
        return result;
    }
}

