/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.gml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.geosparql.implementation.jts.GeometryTransformation;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;
import org.apache.sis.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.io.gml2.GMLReader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;

public class E_Gml2Wkt
extends FunctionBase1 {
    private GMLReader gmlReader = new GMLReader();
    private WKTWriter wktWriter = new WKTWriter();
    private GeometryFactory geometryFactory = new GeometryFactory();

    public NodeValue exec(NodeValue nodeValue) {
        NodeValue result = Expr.NONE.getConstant();
        if (nodeValue.isString()) {
            try {
                String gml = nodeValue.getString();
                Geometry geometry = this.gmlReader.read(gml, this.geometryFactory);
                Pattern p = Pattern.compile("srsName=\\\"([^\"]*)\\\"");
                Matcher m = p.matcher(gml);
                if (m.find()) {
                    String srs = m.group(1);
                    CoordinateReferenceSystem crsSource = CRS.forCode((String)srs);
                    CoordinateReferenceSystem crsTarget = CRS.forCode((String)"CRS:84");
                    CoordinateOperation operation = CRS.findOperation((CoordinateReferenceSystem)crsSource, (CoordinateReferenceSystem)crsTarget, null);
                    MathTransform transform = operation.getMathTransform();
                    geometry = GeometryTransformation.transform((Geometry)geometry, (MathTransform)transform);
                }
                RDFDatatype datatype = TypeMapper.getInstance().getSafeTypeByName("http://www.opengis.net/ont/geosparql#wktLiteral");
                String wktString = this.wktWriter.write(geometry);
                result = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)wktString, (RDFDatatype)datatype));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

