/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;
import org.apache.jena.vocabulary.RDF;
import org.locationtech.jts.io.geojson.GeoJsonWriter;

public class F_AsGeoJSON
extends FunctionBase1 {
    private GeoJsonWriter writer = new GeoJsonWriter();

    public F_AsGeoJSON() {
        this.writer.setForceCCW(true);
        this.writer.setEncodeCRS(false);
    }

    public NodeValue exec(NodeValue v) {
        if (!v.isLiteral()) {
            throw new ARQInternalErrorException("Not a literal: " + String.valueOf(v));
        }
        try {
            GeometryWrapper gw = GeometryWrapper.extract((NodeValue)v);
            GeometryWrapper convertedGeom = gw.transform("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
            String json = this.writer.write(convertedGeom.getParsingGeometry());
            Node node = NodeFactory.createLiteralByValue((Object)json, (RDFDatatype)RDF.dtRDFJSON);
            NodeValue result = NodeValue.makeNode((Node)node);
            return result;
        }
        catch (Exception e) {
            throw new ARQInternalErrorException("Failed to parse literal. Not a geometry?", (Throwable)e);
        }
    }
}

