/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.datatypes;

import java.time.Duration;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDuration;

public class DurationFunctionsJena {
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int MINUTES_PER_DAY = 1440;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    static final long NANOS_PER_MILLI = 1000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    static final long NANOS_PER_DAY = 86400000000000L;
    static final long DAYS_PER_WEEK = 7L;

    @IriNs(value="http://jsa.aksw.org/fn/duration/")
    public static long asWeeks(XSDDuration dur) {
        return DurationFunctionsJena.asDays(dur) / 7L;
    }

    @IriNs(value="http://jsa.aksw.org/fn/duration/")
    public static long asDays(XSDDuration dur) {
        return DurationFunctionsJena.asHours(dur) / 24L;
    }

    @IriNs(value="http://jsa.aksw.org/fn/duration/")
    public static long asHours(XSDDuration dur) {
        return DurationFunctionsJena.asMinutes(dur) / 60L;
    }

    @IriNs(value="http://jsa.aksw.org/fn/duration/")
    public static long asMinutes(XSDDuration dur) {
        return DurationFunctionsJena.asSeconds(dur) / 60L;
    }

    @IriNs(value="http://jsa.aksw.org/fn/duration/")
    public static long asSeconds(XSDDuration dur) {
        return dur.getFullSeconds() + dur.getMinutes() * 60 + dur.getHours() * 3600 + dur.getDays() * 86400;
    }

    @IriNs(value="http://jsa.aksw.org/fn/duration/")
    public static XSDDuration simplify(XSDDuration dur) {
        long seconds = DurationFunctionsJena.asSeconds(dur);
        Duration d = Duration.ofSeconds(seconds);
        return (XSDDuration)XSDDatatype.XSDduration.parseValidated(d.toString());
    }
}

