/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.collection.base;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.aksw.commons.collector.core.AggBuilder;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.commons.lambda.serializable.SerializableBiFunction;
import org.aksw.commons.lambda.serializable.SerializableConsumer;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.jena_sparql_api.sparql.ext.collection.array.SparqlLibArrayAgg;
import org.aksw.jena_sparql_api.sparql.ext.util.AccAdapterJena;
import org.aksw.jenax.arq.util.node.NodeCollection;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.VariableNotBoundException;
import org.apache.jena.sparql.expr.aggregate.AccumulatorFactory;
import org.apache.jena.sparql.function.FunctionEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlLibCollectionAgg {
    private static final Logger logger = LoggerFactory.getLogger(SparqlLibArrayAgg.class);

    public static <T> AccumulatorFactory wrap1(BiFunction<? super Expr, ? super Boolean, ? extends Aggregator<Binding, FunctionEnv, T>> ctor, RDFDatatype rdfDatatype) {
        return (aggCustom, distinct) -> {
            Expr expr = aggCustom.getExpr();
            Aggregator coreAgg = ((Aggregator)ctor.apply(expr, distinct)).finish((SerializableFunction & Serializable)nodeCollection -> {
                Node node = nodeCollection == null ? null : NodeFactory.createLiteralByValue((Object)nodeCollection, (RDFDatatype)rdfDatatype);
                NodeValue r = node == null ? null : NodeValue.makeNode((Node)node);
                return r;
            });
            return new AccAdapterJena((Accumulator<Binding, FunctionEnv, NodeValue>)coreAgg.createAccumulator());
        };
    }

    public static <T> Aggregator<Binding, FunctionEnv, T> aggNodesFromExpr(Expr expr, ParallelAggregator<Node, FunctionEnv, T, ?> agg) {
        return AggBuilder.errorHandler((ParallelAggregator)AggBuilder.inputTransform2((SerializableBiFunction & Serializable)(b, env) -> {
            NodeValue nv;
            try {
                nv = expr.eval(b, env);
            }
            catch (VariableNotBoundException e) {
                nv = null;
            }
            Node node = nv == null ? null : nv.asNode();
            return node;
        }, agg), (boolean)false, (SerializableConsumer & Serializable)ex -> logger.warn("Error while aggregating a nodes", ex), null);
    }

    public static <T> Aggregator<Binding, FunctionEnv, T> aggNodesFromCollectionExpr(Expr expr, ParallelAggregator<Node, FunctionEnv, T, ?> agg) {
        return AggBuilder.errorHandler((ParallelAggregator)AggBuilder.inputFlatMap2((SerializableBiFunction & Serializable)(b, env) -> {
            NodeValue nv;
            try {
                nv = expr.eval(b, env);
            }
            catch (VariableNotBoundException e) {
                nv = null;
            }
            NodeCollection nc = nv == null ? null : NodeCollection.extractOrNull((Node)nv.asNode());
            Iterator r = nc == null ? Collections.emptyIterator() : nc.iterator();
            return r;
        }, agg), (boolean)false, (SerializableConsumer & Serializable)ex -> logger.warn("Error while aggregating a nodes", ex), null);
    }
}

