/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.benchmark;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import org.aksw.commons.io.util.UriUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;

public class FN_SparqlQueryRewrite_ToService
extends FunctionBase2 {
    public NodeValue exec(NodeValue serviceNv, NodeValue queryNv) {
        String serviceUriStr = serviceNv.asNode().getLiteralLexicalForm();
        String queryStr = queryNv.asNode().getLiteralLexicalForm();
        Query baseQuery = QueryFactory.create((String)queryStr);
        DatasetDescription dd = baseQuery.getDatasetDescription();
        String finalUriStr = serviceUriStr;
        if (dd != null && !dd.isEmpty()) {
            try {
                URI uri = new URI(serviceUriStr);
                List args = UriUtils.parseQueryStringAsList((String)uri.getRawQuery());
                dd.getDefaultGraphURIs().forEach(item -> args.add(new AbstractMap.SimpleEntry<String, String>("default-graph-uri", (String)item)));
                dd.getNamedGraphURIs().forEach(item -> args.add(new AbstractMap.SimpleEntry<String, String>("named-graph-uri", (String)item)));
                String newQueryString = UriUtils.toQueryString((Collection)args);
                finalUriStr = UriUtils.replaceQueryString((URI)uri, (String)newQueryString).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        Query modifiedBaseQuery = QueryTransformOps.shallowCopy((Query)baseQuery);
        modifiedBaseQuery.setQuerySelectType();
        modifiedBaseQuery.getPrefixMapping().clearNsPrefixMap();
        modifiedBaseQuery.getGraphURIs().clear();
        modifiedBaseQuery.getNamedGraphURIs().clear();
        modifiedBaseQuery.setLimit(Long.MIN_VALUE);
        modifiedBaseQuery.setOffset(Long.MIN_VALUE);
        Query newQuery = new Query();
        newQuery.setQuerySelectType();
        newQuery.setQueryResultStar(true);
        newQuery.setQueryPattern((Element)new ElementService(finalUriStr, (Element)new ElementSubQuery(modifiedBaseQuery)));
        Query finalQuery = QueryUtils.restoreQueryForm((Query)newQuery, (Query)baseQuery);
        finalQuery.getGraphURIs().clear();
        finalQuery.getNamedGraphURIs().clear();
        finalQuery.setLimit(baseQuery.getLimit());
        finalQuery.setOffset(baseQuery.getOffset());
        return NodeValue.makeString((String)finalQuery.toString());
    }
}

