/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.List;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;

public class E_JsonStrSplit
extends FunctionBase {
    public NodeValue exec(List<NodeValue> args) {
        int l;
        NodeValue result = null;
        NodeValue haystack = args.get(0);
        NodeValue needle = args.get(1);
        NodeValue limit = args.size() > 2 ? args.get(2) : null;
        int n = l = limit == null || !limit.isInteger() ? -1 : limit.getInteger().intValue();
        if (haystack.isString() && needle.isString()) {
            RDFDatatype jsonDatatype = TypeMapper.getInstance().getTypeByClass(JsonElement.class);
            String h = haystack.getString();
            String n2 = needle.getString();
            String[] strs = h.split(n2, l);
            JsonArray arr = new JsonArray();
            for (String str : strs) {
                arr.add(str);
            }
            Node node = NodeFactory.createLiteralByValue((Object)arr, (RDFDatatype)jsonDatatype);
            result = NodeValue.makeNode((Node)node);
        }
        if (result == null) {
            throw new ExprEvalException("could not split a string based on given arguments");
        }
        return result;
    }

    public void checkBuild(String uri, ExprList args) {
        int n = args.size();
        if (n != 2 && n != 3) {
            throw new RuntimeException("strSplit expects 2 or 3 args");
        }
    }
}

