/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.quadtree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aksw.commons.collections.quadtree.QuadTreeNode;
import org.locationtech.jts.geom.Envelope;

public class LooseQuadTree<T> {
    protected double k;
    protected QuadTreeNode<T> rootNode;
    protected Map<Object, QuadTreeNode<T>> idToNodes;

    public LooseQuadTree(Envelope bounds, int maxDepth, float k) {
        this.k = k;
        this.rootNode = new QuadTreeNode(null, 0, bounds, maxDepth, 0, k);
        this.idToNodes = new LinkedHashMap<Object, QuadTreeNode<T>>();
    }

    public QuadTreeNode<T> getRootNode() {
        return this.rootNode;
    }

    public Collection<QuadTreeNode<T>> acquireNodes(Envelope bounds, int depth) {
        return this.rootNode.acquireNodes(bounds, depth);
    }

    public List<?> query(Envelope bounds, int depth) {
        return this.rootNode.query(bounds, depth);
    }
}

