/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.util.function.Supplier;
import org.aksw.commons.util.memoize.MemoizedSupplierImpl;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.vocabulary.XSD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFDatatypeJson
extends BaseDatatype {
    private static final Logger logger = LoggerFactory.getLogger(RDFDatatypeJson.class);
    public static final String LEGACY_IRI = XSD.getURI() + "json";
    private static final RDFDatatypeJson INSTANCE = new RDFDatatypeJson();
    private Supplier<Gson> gsonSupplier;

    public static RDFDatatypeJson get() {
        return INSTANCE;
    }

    public RDFDatatypeJson() {
        this("https://w3id.org/aksw/norse#json");
    }

    public RDFDatatypeJson(String uri) {
        this(uri, () -> RDFDatatypeJson.createGson());
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        try {
            builder.setLenient();
        }
        catch (NoSuchMethodError e) {
            logger.warn("Gson.setLenient not available");
        }
        try {
            builder.setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE);
            builder.setNumberToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE);
        }
        catch (NoSuchMethodError e) {
            logger.warn("Gson.setObjectToNumberStrategy and/or Gson.setNumberToNumberStrategy not available");
        }
        Gson result = builder.create();
        return result;
    }

    public boolean isValidValue(Object valueForm) {
        boolean result = valueForm instanceof JsonElement;
        return result;
    }

    public RDFDatatypeJson(String uri, Supplier<Gson> gsonSupplier) {
        super(uri);
        this.gsonSupplier = MemoizedSupplierImpl.of(gsonSupplier);
    }

    public Gson getGson() {
        return this.gsonSupplier.get();
    }

    public Class<?> getJavaClass() {
        return JsonElement.class;
    }

    public String unparse(Object value) {
        String result = JenaJsonUtils.convertJsonOrValueToString(value, this.getGson());
        return result;
    }

    public JsonElement parse(String lexicalForm) throws DatatypeFormatException {
        JsonElement result;
        try {
            result = (JsonElement)this.getGson().fromJson(lexicalForm, JsonElement.class);
        }
        catch (Exception e) {
            throw new DatatypeFormatException(lexicalForm, (RDFDatatype)this, (Throwable)e);
        }
        return result;
    }
}

