/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.geosparql;

import org.aksw.jena_sparql_api.sparql.ext.geosparql.GeometryWrapperUtils;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.jts.CustomGeometryFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase3;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.triangulate.VoronoiDiagramBuilder;

public class F_ST_VoronoiPolygons
extends FunctionBase3 {
    public NodeValue exec(NodeValue v, NodeValue toleranceV, NodeValue envelope) {
        if (v != null) {
            GeometryWrapper geom = GeometryWrapper.extract((NodeValue)v);
            VoronoiDiagramBuilder builder = new VoronoiDiagramBuilder();
            builder.setSites(geom.getXYGeometry());
            if (toleranceV != null && toleranceV.isDouble()) {
                double tolerance = toleranceV.getDouble();
                builder.setTolerance(tolerance);
            }
            GeometryWrapper env = null;
            if (envelope != null) {
                env = GeometryWrapper.extract((NodeValue)envelope);
                builder.setClipEnvelope(env.getEnvelope());
            }
            Geometry result = builder.getDiagram(CustomGeometryFactory.theInstance());
            GeometryWrapper voronoiWrapper = GeometryWrapperUtils.createFromPrototype(geom, result);
            return voronoiWrapper.asNodeValue();
        }
        throw new ExprEvalException("VoronoiPolygons requires geometry argument");
    }
}

