/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.csv;

import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.aksw.jena_sparql_api.sparql.ext.csv.CsvFormatParser;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E_CsvParse
extends FunctionBase2 {
    private static final Logger logger = LoggerFactory.getLogger(E_CsvParse.class);

    public static Stream<JsonElement> parseCsv(Reader reader, String optionStr) throws IOException {
        String[] args;
        try {
            args = CommandLineUtils.translateCommandline((String)optionStr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder rowAsObjectOs = optionParser.acceptsAll(Arrays.asList("o"), "Output rows as objects");
        OptionSpecBuilder firstRowAsHeadersOs = optionParser.acceptsAll(Arrays.asList("h"), "First row as headers");
        CsvFormatParser csvFormatParser = new CsvFormatParser(optionParser);
        OptionSet options = optionParser.parse(args);
        CSVFormat csvFormat = csvFormatParser.parse(options, CSVFormat.EXCEL);
        boolean firstRowAsHeaders = options.has((OptionSpec)firstRowAsHeadersOs);
        boolean rowAsObject = options.has((OptionSpec)rowAsObjectOs) || firstRowAsHeaders;
        Stream<JsonElement> result = E_CsvParse.parseCsv(reader, csvFormat, rowAsObject, firstRowAsHeaders);
        return result;
    }

    public static JsonArray csvRecordToJsonArray(CSVRecord row) {
        JsonArray result = new JsonArray();
        for (int i = 0; i < row.size(); ++i) {
            String value = row.get(i);
            result.add(value);
        }
        return result;
    }

    public static JsonObject csvRecordToJsonObject(CSVRecord row, String[] labels) {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < row.size(); ++i) {
            String value = row.get(i);
            String label = labels != null && i < labels.length ? labels[i] : null;
            label = label == null ? "col" + i : label;
            obj.addProperty(label, value);
        }
        return obj;
    }

    public static Stream<JsonElement> parseCsv(Reader reader, CSVFormat csvFormat, boolean rowAsObject, boolean firstRowAsLabels) throws IOException {
        CSVParser csvParser;
        try {
            csvParser = new CSVParser(reader, csvFormat);
        }
        catch (IOException e) {
            reader.close();
            throw new RuntimeException(e);
        }
        Iterator it = csvParser.iterator();
        String[] tmp = null;
        if (firstRowAsLabels && it.hasNext()) {
            CSVRecord r2 = (CSVRecord)it.next();
            tmp = (String[])Iterators.toArray((Iterator)r2.iterator(), String.class);
        }
        String[] labels = tmp;
        Function<CSVRecord, JsonElement> rowJsonEncoder = rowAsObject ? r -> E_CsvParse.csvRecordToJsonObject(r, labels) : E_CsvParse::csvRecordToJsonArray;
        Stream rowObjStream = (Stream)Streams.stream((Iterator)it).map(x -> (JsonElement)rowJsonEncoder.apply((CSVRecord)x)).onClose(() -> {
            try {
                csvParser.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return rowObjStream;
    }

    public NodeValue exec(NodeValue v1, NodeValue v2) {
        Stream<Object> rowObjStream;
        String csvStr;
        String string = csvStr = v1.isString() ? v1.getString() : null;
        String optionStr = v2.isBlank() ? "" : (v2.isString() ? v2.getString() : null);
        try {
            rowObjStream = E_CsvParse.parseCsv(new StringReader(csvStr), optionStr);
        }
        catch (IOException e) {
            logger.warn("Failed to parse csv input", (Throwable)e);
            rowObjStream = Collections.emptySet().stream();
        }
        JsonArray arr = new JsonArray();
        rowObjStream.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
        Node node = JenaJsonUtils.createLiteralByValue((JsonElement)arr);
        NodeValue result = NodeValue.makeNode((Node)node);
        return result;
    }
}

