/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.rs;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;
import org.slf4j.Logger;

public class ResultSetWriterMarkdown
implements ResultSetWriter {
    public static final Lang RS_Markdown = LangBuilder.create((String)"SPARQL-Results-Markdown", (String)"text/markdown").addFileExtensions(new String[]{"md"}).build();
    public static ResultSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, RS_Markdown)) {
            throw new ResultSetException("ResultSetWriter for Text asked for a " + String.valueOf(lang));
        }
        return new ResultSetWriterMarkdown();
    };
    private static final String NL = "\n";
    private static final String notThere = " ";

    private ResultSetWriterMarkdown() {
    }

    public void write(OutputStream out, ResultSet resultSet, Context context) {
        ResultSetWriterMarkdown.output(IO.wrapUTF8((OutputStream)out), resultSet, context);
    }

    public void write(Writer out, ResultSet resultSet, Context context) {
        ResultSetWriterMarkdown.output(IO.wrap((Writer)out), resultSet, context);
    }

    public void write(OutputStream out, boolean result, Context context) {
        this.output(IO.wrapUTF8((OutputStream)out), result, context);
    }

    private void output(AWriter out, boolean result, Context context) {
        if (result) {
            out.write("yes");
        } else {
            out.write("no");
        }
        out.write(NL);
        out.flush();
    }

    private static int[] colWidths(ResultSetRewindable rs, SerializationContext context) {
        int numCols = rs.getResultVars().size();
        int numRows = 0;
        int[] colWidths = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            colWidths[i] = ((String)rs.getResultVars().get(i)).length();
        }
        while (rs.hasNext()) {
            ++numRows;
            QuerySolution rBind = rs.nextSolution();
            int col = -1;
            for (String s1 : rs.getResultVars()) {
                String rVar = s1;
                String s = ResultSetWriterMarkdown.getVarValueAsString(rBind, rVar, context);
                if (colWidths[++col] >= s.length()) continue;
                colWidths[col] = s.length();
            }
        }
        rs.reset();
        return colWidths;
    }

    public static void output(AWriter out, ResultSet resultSet, String colStart, String colSep, String colEnd) {
        ResultSetWriterMarkdown.output(out, resultSet, colStart, colSep, colEnd, null);
    }

    public static void output(AWriter out, ResultSet resultSet, Context cxt) {
        ResultSetWriterMarkdown.output(out, resultSet, "| ", " | ", " |", cxt);
    }

    public static void output(AWriter out, ResultSet resultSet, String colStart, String colSep, String colEnd, Context cxt) {
        ResultSetWriterMarkdown.output$(out, resultSet, colStart, colSep, colEnd, cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void output$(AWriter out, ResultSet resultSet, String colStart, String colSep, String colEnd, Context cxt) {
        Prologue prologue = ResultSetWriterMarkdown.choosePrologue(resultSet, cxt);
        SerializationContext context = new SerializationContext(prologue);
        try {
            int i;
            if (resultSet.getResultVars().size() == 0) {
                out.println("==== No variables ====");
            }
            ResultSetRewindable resultSetRewindable = resultSet.rewindable();
            int numCols = resultSetRewindable.getResultVars().size();
            int[] colWidths = ResultSetWriterMarkdown.colWidths(resultSetRewindable, context);
            String[] row = new String[numCols];
            int lineWidth = 0;
            for (int col = 0; col < numCols; ++col) {
                String rVar;
                row[col] = rVar = (String)resultSet.getResultVars().get(col);
                lineWidth += colWidths[col];
                if (col <= 0) continue;
                lineWidth += colSep.length();
            }
            if (colStart != null) {
                lineWidth += colStart.length();
            }
            if (colEnd != null) {
                lineWidth += colEnd.length();
            }
            for (i = 0; i < lineWidth; ++i) {
                out.print('-');
            }
            out.println();
            ResultSetWriterMarkdown.printRow(out, row, colWidths, colStart, colSep, colEnd);
            for (i = 0; i < lineWidth; ++i) {
                out.print('=');
            }
            out.println();
            while (resultSetRewindable.hasNext()) {
                QuerySolution rBind = resultSetRewindable.nextSolution();
                for (int col = 0; col < numCols; ++col) {
                    String rVar = (String)resultSet.getResultVars().get(col);
                    row[col] = ResultSetWriterMarkdown.getVarValueAsString(rBind, rVar, context);
                }
                ResultSetWriterMarkdown.printRow(out, row, colWidths, colStart, colSep, colEnd);
            }
            for (i = 0; i < lineWidth; ++i) {
                out.print('-');
            }
            out.println();
            resultSetRewindable = null;
        }
        finally {
            out.flush();
        }
    }

    private static void printRow(AWriter out, String[] row, int[] colWidths, String rowStart, String colSep, String rowEnd) {
        out.print(rowStart);
        for (int col = 0; col < colWidths.length; ++col) {
            String s = row[col];
            int pad = colWidths[col];
            StringBuffer sbuff = new StringBuffer(120);
            if (col > 0) {
                sbuff.append(colSep);
            }
            sbuff.append(s);
            for (int j = 0; j < pad - s.length(); ++j) {
                sbuff.append(' ');
            }
            out.print(sbuff.toString());
        }
        out.print(rowEnd);
        out.println();
    }

    private static String getVarValueAsString(QuerySolution rBind, String varName, SerializationContext context) {
        RDFNode obj = rBind.get(varName);
        if (obj == null) {
            return notThere;
        }
        return FmtUtils.stringForRDFNode((RDFNode)obj, (SerializationContext)context);
    }

    private static Prologue choosePrologue(ResultSet resultSet, Context context) {
        try {
            if (context != null && context.get(ARQConstants.symPrologue) != null) {
                return (Prologue)context.get(ARQConstants.symPrologue);
            }
            Model m = resultSet.getResourceModel();
            if (m != null) {
                return new Prologue((PrefixMapping)m);
            }
        }
        catch (Exception ex) {
            FmtLog.warn((Logger)ARQ.getExecLogger(), (String)"Failed to establish a 'Prologue' for text output: %s", (Object[])new Object[]{ex.getMessage()});
        }
        return null;
    }
}

