/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.url;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;

public class E_IriAsGiven
extends FunctionBase1 {
    public static final String tagIriAsGiven = "iriAsGiven";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeValue exec(NodeValue nv) {
        if (nv == null) throw new ExprEvalException("E_IriAsGiven: Called with null / unbound");
        if (nv.isString()) {
            return NodeValue.makeNode((Node)NodeFactory.createURI((String)nv.getString()));
        }
        if (!nv.hasNode()) throw new ExprEvalException("E_IriAsGiven: Argument is neither string nor node");
        if (!nv.asNode().isURI()) throw new ExprEvalException("E_IriAsGiven: Argument is not an IRI");
        return nv;
    }

    public static class ExprTransformIriToIriAsGiven
    extends ExprTransformCopy {
        private static final ExprTransformIriToIriAsGiven INSTANCE = new ExprTransformIriToIriAsGiven();
        public static String IRI = "http://jsa.aksw.org/fn/iri/asGiven";

        public static ExprTransform get() {
            return INSTANCE;
        }

        public Expr transform(ExprFunction1 func, Expr expr1) {
            E_Function result = func instanceof E_IRI ? new E_Function(IRI, new ExprList(expr1)) : super.transform(func, expr1);
            return result;
        }

        public static Expr transform(Expr expr) {
            return ExprTransformer.transform((ExprTransform)ExprTransformIriToIriAsGiven.get(), (Expr)expr);
        }

        public static Element transformElt(Element element) {
            Element result = ElementTransformer.transform((Element)element, (ElementTransform)new ElementTransformCopyBase(true), (ExprTransform)ExprTransformIriToIriAsGiven.get());
            return result;
        }
    }
}

