/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.csv;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import org.aksw.jena_sparql_api.sparql.ext.csv.ValueConverterCharacter;
import org.apache.commons.csv.CSVFormat;

public class CsvFormatParser {
    public static final CSVFormat DEFAULT_CSV_FORMAT = CSVFormat.EXCEL;
    protected CSVFormat defaultCsvFormat;
    protected NonOptionArgumentSpec<String> baseCsvFormatOs;
    protected OptionSpec<Character> fieldDelimiterOs;
    protected OptionSpec<Character> quoteOs;
    protected OptionSpec<Character> escapeCharacterOs;
    protected OptionParser optionParser;
    protected Map<String, String> predefinedFormats;

    public CsvFormatParser() {
        this(new OptionParser());
    }

    public CsvFormatParser(OptionParser optionParser) {
        this.optionParser = optionParser;
        this.defaultCsvFormat = DEFAULT_CSV_FORMAT;
        this.initOptionSpecs();
    }

    public OptionParser getOptionParser() {
        return this.optionParser;
    }

    public void initOptionSpecs() {
        this.predefinedFormats = Arrays.asList(CSVFormat.Predefined.values()).stream().map(Enum::name).collect(Collectors.toMap(String::toLowerCase, x -> x, (u, v) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
        this.baseCsvFormatOs = this.optionParser.nonOptions("Base predefined CSV format, one of " + String.valueOf(this.predefinedFormats.values()));
        this.quoteOs = this.optionParser.acceptsAll(Arrays.asList("q", "quote"), "CSV field quote character").withOptionalArg().withValuesConvertedBy((ValueConverter)new ValueConverterCharacter()).defaultsTo((Object)this.defaultCsvFormat.getQuoteCharacter(), (Object[])new Character[0]);
        this.fieldDelimiterOs = this.optionParser.acceptsAll(Arrays.asList("d", "delimiter"), "CSV field delimiter").withRequiredArg().withValuesConvertedBy((ValueConverter)new ValueConverterCharacter()).defaultsTo((Object)Character.valueOf(this.defaultCsvFormat.getDelimiter()), (Object[])new Character[0]);
        this.escapeCharacterOs = this.optionParser.acceptsAll(Arrays.asList("e", "escape"), "CSV field escape symbol").withOptionalArg().withValuesConvertedBy((ValueConverter)new ValueConverterCharacter());
    }

    public CSVFormat parse(OptionSet options, CSVFormat fallBackCsvFormat) {
        CSVFormat csvFormat = null;
        if (options.has(this.baseCsvFormatOs)) {
            String baseFormat = (String)this.baseCsvFormatOs.value(options);
            String string = baseFormat = baseFormat == null ? "" : baseFormat.trim().toLowerCase();
            if (!baseFormat.isEmpty()) {
                String formatId = this.predefinedFormats.get(baseFormat);
                if (formatId != null) {
                    csvFormat = CSVFormat.valueOf((String)formatId);
                } else {
                    throw new RuntimeException("No CSV format known by name '" + formatId + "', available: " + String.valueOf(this.predefinedFormats.values()));
                }
            }
        }
        if (csvFormat == null) {
            csvFormat = fallBackCsvFormat;
        }
        if (csvFormat == null) {
            csvFormat = CSVFormat.EXCEL;
        }
        if (csvFormat == null) {
            csvFormat = this.defaultCsvFormat;
        }
        csvFormat = csvFormat.withDelimiter(((Character)this.fieldDelimiterOs.value(options)).charValue()).withQuote((Character)this.quoteOs.value(options)).withEscape((Character)this.escapeCharacterOs.value(options));
        return csvFormat;
    }
}

