/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.binding;

import org.aksw.jena_sparql_api.sparql.ext.binding.NodeValueBinding;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;

public class JenaBindingUtils {
    public static Binding requireBinding(NodeValue nv) {
        Binding elt = JenaBindingUtils.extractBindingOrNull(nv);
        if (elt == null) {
            NodeValue.raise((ExprException)new ExprTypeException("Not a Binding"));
        }
        return elt;
    }

    public static Binding extractBindingOrNull(NodeValue nv) {
        Binding result = null;
        if (nv instanceof NodeValueBinding) {
            result = ((NodeValueBinding)nv).getBinding();
        } else {
            Node node = nv.getNode();
            if (node != null) {
                result = JenaBindingUtils.extractOrNull(node);
            }
        }
        return result;
    }

    public static Binding extractOrNull(Node node) {
        Object value;
        Binding result = null;
        if (node.isLiteral() && (value = node.getLiteralValue()) instanceof Binding) {
            result = (Binding)value;
        }
        return result;
    }
}

