/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.number;

import java.util.Iterator;
import java.util.List;
import java.util.stream.LongStream;
import org.aksw.jena_sparql_api.sparql.ext.util.PropFuncArgUtils;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.IterLib;

public class PF_Range
extends PropertyFunctionBase {
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        QueryIterator result;
        List<Node> subjects = PropFuncArgUtils.getAsList(argSubject);
        int sn = subjects.size();
        if (sn < 2 || sn > 4) {
            throw new ExprEvalException("Expected at least 2 and up to 4 arguments (start, end [, increment [, displacement]]), got: " + String.valueOf(subjects));
        }
        List<Node> objects = PropFuncArgUtils.getAsList(argObject);
        int on = objects.size();
        if (on != 1) {
            throw new ExprEvalException("Expected only 1 argument, got: " + String.valueOf(objects));
        }
        long displacement = BindingUtils.tryGetNumber((Binding)binding, sn > 3 ? subjects.get(3) : null).map(Number::longValue).orElse(0L);
        long start = BindingUtils.getNumber((Binding)binding, (Node)subjects.get(0)).longValue() + displacement;
        long end = BindingUtils.getNumber((Binding)binding, (Node)subjects.get(1)).longValue() + displacement;
        long step = BindingUtils.tryGetNumber((Binding)binding, sn > 2 ? subjects.get(2) : null).map(Number::longValue).orElse(1L);
        long rangeDelta = end - start;
        long stepDir = Long.signum(step);
        if (stepDir <= 0L) {
            result = IterLib.noResults((ExecutionContext)execCxt);
        } else {
            Node outputNode = objects.get(0);
            Number outputValue = BindingUtils.getNumberNullable((Binding)binding, (Node)outputNode);
            if (outputValue != null) {
                boolean isMultipleOfStep;
                long tmp = outputValue.longValue();
                boolean bl = isMultipleOfStep = (tmp - start) % step == 0L;
                boolean isInRange = rangeDelta >= 0L ? tmp >= start && tmp < end : tmp <= start && tmp > end;
                result = isInRange && isMultipleOfStep ? IterLib.result((Binding)binding, (ExecutionContext)execCxt) : IterLib.noResults((ExecutionContext)execCxt);
            } else {
                Var outputVar = (Var)outputNode;
                LongStream base = rangeDelta >= 0L ? LongStream.iterate(start, x -> x < end, x -> x + step) : LongStream.iterate(start, x -> x > end, x -> x - step);
                Iterator it = base.mapToObj(v -> BindingFactory.binding((Binding)binding, (Var)outputVar, (Node)NodeValue.makeInteger((long)v).asNode())).iterator();
                result = QueryIterPlainWrapper.create(it, (ExecutionContext)execCxt);
            }
        }
        return result;
    }
}

