/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql.ext.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.aksw.jenax.annotation.reprogen.DefaultValue;
import org.aksw.jenax.arq.datatype.RDFDatatypeBinding;
import org.aksw.jenax.arq.functionbinder.FunctionBinders;
import org.aksw.jenax.arq.util.expr.FunctionUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.pfunction.PFuncSimpleAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;

public class PropertyFunctionFactoryJsonExplode
implements PropertyFunctionFactory {
    public static Function FN_EXPLODE;

    public static Binding explode(JsonElement json, @DefaultValue(value="_") String varPrefix, @DefaultValue(value="0") int offset) {
        Binding result = PropertyFunctionFactoryJsonExplode.explode(json, null, varPrefix, offset);
        return result;
    }

    public PropertyFunction create(String uri) {
        return new PFuncSimpleAndList(){

            public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, PropFuncArg objects, ExecutionContext execCxt) {
                Node node = subject.isVariable() ? binding.get((Var)subject) : subject;
                ArrayList<Node> args = new ArrayList<Node>(1 + objects.getArgListSize());
                args.add(node);
                args.addAll(objects.getArgList());
                Node n = FunctionUtils.invokeWithNodes((Function)FN_EXPLODE, args);
                Binding contrib = RDFDatatypeBinding.extractBinding((Node)n);
                Binding tmp = BindingFactory.builder((Binding)binding).addAll(contrib).build();
                QueryIterator result = PropertyFunctionFactoryJsonExplode.ofNullableBinding(tmp, execCxt);
                return result;
            }
        };
    }

    public static QueryIterator ofNullableBinding(Binding b, ExecutionContext execCxt) {
        return b == null ? QueryIterNullIterator.create((ExecutionContext)execCxt) : QueryIterSingleton.create((Binding)b, (ExecutionContext)execCxt);
    }

    public static Binding explode(Node node, Binding parent, String varPrefix, int offset) {
        JsonElement json = JenaJsonUtils.extractOrNull(node);
        Binding result = PropertyFunctionFactoryJsonExplode.explode(json, parent, varPrefix, offset);
        return result;
    }

    public static Binding explode(JsonElement json, Binding parent, String varPrefix, int offset) {
        Binding result;
        if (json == null) {
            throw new ExprEvalException("Not a json element");
        }
        if (json.isJsonArray()) {
            JsonArray arr = json.getAsJsonArray();
            result = PropertyFunctionFactoryJsonExplode.explode(arr, parent, varPrefix, offset);
        } else if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            result = PropertyFunctionFactoryJsonExplode.explode(obj, parent, varPrefix);
        } else {
            throw new ExprEvalException("Neither a json array nor a json object");
        }
        return result;
    }

    public static Binding explode(JsonArray arr, Binding parent, String varPrefix, int offset) {
        BindingBuilder builder = BindingFactory.builder((Binding)parent);
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            JsonElement item = arr.get(i);
            Object str = Integer.toString(offset + i);
            if (varPrefix != null && !varPrefix.isEmpty()) {
                str = varPrefix + (String)str;
            }
            Var v = Var.alloc((String)str);
            Node n = JenaJsonUtils.createLiteralByValue(item);
            builder.add(v, n);
        }
        Binding result = builder.build();
        return result;
    }

    public static Binding explode(JsonObject obj, Binding parent, String varPrefix) {
        BindingBuilder builder = BindingFactory.builder((Binding)parent);
        for (Map.Entry e : obj.entrySet()) {
            Object str = (String)e.getKey();
            if (varPrefix != null && !varPrefix.isEmpty()) {
                str = varPrefix + (String)str;
            }
            Var v = Var.alloc((String)str);
            Node n = JenaJsonUtils.createLiteralByValue((JsonElement)e.getValue());
            builder.add(v, n);
        }
        Binding result = builder.build();
        return result;
    }

    static {
        try {
            FN_EXPLODE = FunctionBinders.getDefaultFunctionBinder().getFunctionGenerator().wrap(PropertyFunctionFactoryJsonExplode.class.getDeclaredMethod("explode", JsonElement.class, String.class, Integer.TYPE));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

